/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.web.cmd.attachment.large;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.cmd.attachment.large.table.AttachmentTable;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.file.provider.IAttachmentProvider;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class UploadLargeAttachmentCmd
extends DefaultServiceCmd {
    private String formKey = "";
    private String tableKey = "";
    private String provider = "";
    private long SOID = -1L;
    private String seriesPath = "";
    private FileData fileData = null;
    private String fileName = null;
    private int chunks = 1;
    private int chunk = 0;
    private String fileMD5 = null;
    private long fileSize = 0L;
    private long oid = 0L;

    public UploadLargeAttachmentCmd() {
    }

    public UploadLargeAttachmentCmd(FileData fileData, String string, String string2, long l, long l2, long l3, String string3, String string4, long l4, boolean bl, String string5) {
        this.fileData = fileData;
        this.formKey = string;
        this.tableKey = string2;
        this.SOID = l;
        this.seriesPath = string4;
        this.provider = string5;
    }

    public void dealArguments(DefaultContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        this.seriesPath = TypeConvertor.toString((Object)stringHashMap.get((Object)"seriesPath"));
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        this.tableKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"tableKey"));
        this.tableKey = this.tableKey.isEmpty() ? "USER_Attachment" : this.tableKey;
        this.provider = TypeConvertor.toString((Object)stringHashMap.get((Object)"provider"));
        this.SOID = Long.parseLong(stringHashMap.get((Object)"soid").toString());
        object = (List)stringHashMap.get((Object)"fileDatas");
        this.fileData = object != null && object.size() > 0 ? (FileData)object.get(0) : null;
        this.fileName = TypeConvertor.toString((Object)stringHashMap.get((Object)"name"));
        this.chunks = stringHashMap.get((Object)"chunks") != null ? TypeConvertor.toInteger((Object)stringHashMap.get((Object)"chunks")) : 1;
        this.chunk = stringHashMap.get((Object)"chunk") != null ? TypeConvertor.toInteger((Object)stringHashMap.get((Object)"chunk")) : 0;
        this.fileMD5 = TypeConvertor.toString((Object)stringHashMap.get((Object)"fileMD5"));
        this.fileSize = TypeConvertor.toLong((Object)stringHashMap.get((Object)"size"));
        this.oid = TypeConvertor.toLong((Object)stringHashMap.get((Object)"fileOID"));
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        Object object = AttachmentUtil.getAttachMetaTable((IMetaFactory)defaultContext.getVE().getMetaFactory(), (String)this.formKey, (String)this.tableKey);
        object = new AttachmentTable((MetaTable)object);
        ((AttachmentTable)object).updateUploadProcess(defaultContext, this.oid, this.fileMD5, "uploading", this.fileData.getSize());
        Object object2 = AttachmentTable.getTempFilePath() + File.separator + this.fileMD5;
        object2 = new File((String)object2);
        if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        File file = new File((File)object2, this.chunk + ".part");
        FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(this.fileData.getData()), (File)file);
        boolean bl = true;
        for (int j = 0; j < this.chunks; ++j) {
            if (new File((File)object2, j + ".part").exists()) continue;
            bl = false;
        }
        if (bl) {
            IAttachmentProvider iAttachmentProvider = AttachmentUtil.newProvider((String)this.provider, (VE)defaultContext.getVE());
            for (int j = 0; j < this.chunks; ++j) {
                byte[] byArray = FileUtils.readFileToByteArray((File)new File((File)object2, j + ".part"));
                iAttachmentProvider.uploadLarge(defaultContext, this.fileName, this.formKey, this.SOID, this.seriesPath, byArray);
            }
            FileUtils.deleteDirectory((File)object2);
            ((AttachmentTable)object).completeUpload(defaultContext, this.oid, this.fileMD5, "completed", this.fileSize);
        } else if (this.chunk == this.chunks - 1) {
            FileUtils.deleteDirectory((File)object2);
        }
        return Boolean.TRUE;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new UploadLargeAttachmentCmd();
    }

    public String getCmd() {
        return "UploadLargeFile";
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

