package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRow;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class TableLayoutJSONBuilder extends AbstractJSONBuilder<MetaTableLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTableLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));

		if (meta.getColumnCollection() != null && meta.getColumnCollection().size() > 0) {
			JSONArray columnWidthArray = new JSONArray();
			Iterator<MetaLayoutColumn> it = meta.getColumnCollection().iterator();
			while (it.hasNext()) {
				MetaLayoutColumn metaLayoutColumn = it.next();
				DefSize width = metaLayoutColumn.getWidth();
				columnWidthArray.put(width == null ? JSONObject.NULL : width.toString());
			}
			json.put("widths", columnWidthArray);
		}

		if (meta.getRowCollection() != null && meta.getRowCollection().size() > 0) {
			JSONArray rowHeightArray = new JSONArray();
			Iterator<MetaLayoutRow> it = meta.getRowCollection().iterator();
			while (it.hasNext()) {
				MetaLayoutRow metaLayoutRow = it.next();
				DefSize height = metaLayoutRow.getHeight();
				rowHeightArray.put(height == null ? JSONObject.NULL : height.toString());
			}
			json.put("heights", rowHeightArray);
		}

		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutSpan> it = meta.iterator();
		while (it.hasNext()) {
			MetaLayoutSpan metaLayoutSpan = it.next();
			JSONObject layoutSpanObj = new JSONObject();
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.COMMON_KEY, metaLayoutSpan.getKey(), "");
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_X, metaLayoutSpan.getX(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_XSPAN, metaLayoutSpan.getXSpan(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_Y, metaLayoutSpan.getY(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_YSPAN, metaLayoutSpan.getYSpan(), -1);
			itemArray.put(layoutSpanObj);
		}

		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
