package com.bokesoft.yes.mid.web.ui.load.tableview;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.tools.ve.VE;

public class TableViewJSONBuilder extends BaseComponentJSONBuilder<MetaTableView> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTableView meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		JSONHelper.writeToJSON(json, "itemAnim", meta.getItemAnim(), ItemAnimType.FADEIN);
		JSONHelper.writeToJSON(json, "layoutAnim", meta.getLayoutAnim(), "");
		JSONArray rows = new JSONArray();
		for (int i = 0; i < meta.getRows().size(); i++) {
			MetaTableRow row = meta.getRows().get(i);
			JSONObject rowObj = builder.build(ve, builder, metaForm, row);
			rows.put(rowObj);
		}
		json.put("items", rows);
	}
}