package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandle;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandleEnum;
import com.bokesoft.yigo.tools.ve.VE;
import org.json.JSONObject;

/*
 *文件名: HandleJSONBuilder
 *创建者: zhangk
 *创建时间:2022/9/13 14:45
 */
public class HandleJSONBuilder extends AbstractJSONBuilder<MetaHandle> {
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaHandle meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, MetaHandleEnum.getNameByType(meta.getType()));
		json.put(JSONConstants.COMMON_X, meta.getX());
		json.put(JSONConstants.COMMON_Y, meta.getY());
		json.put(JSONConstants.LAYOUTSPAN_ITEM_XSPAN, meta.getxSpan());
		json.put(JSONConstants.LAYOUTSPAN_ITEM_YSPAN, meta.getySpan());
		json.put(JSONConstants.EXPAND_STYLE_CLASS, meta.getExpandStyleClass());
		json.put(JSONConstants.COLLAPSE_STYLE_CLASS, meta.getCollapseStyleClass());
		MetaFormat formatMeta = meta.getFormat();
		JSONObject formatJSON = new JSONObject();
		if (formatMeta != null) {
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_FORECOLOR, formatMeta.getForeColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_BACKCOLOR, formatMeta.getBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR,
					formatMeta.getHighlightBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HALIGN, formatMeta.getHAlign(), -1);
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_VALIGN, formatMeta.getVAlign(), -1);
			JSONObject fontJSON = new JSONObject();
			MetaFont fontMeta = formatMeta.getFont();
			if (fontMeta != null) {
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_NAME, fontMeta.getName(), "");
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_SIZE, fontMeta.getSize(), -1);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_BOLD, fontMeta.isBold(), true);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_ITALIC, fontMeta.isItalic(), false);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_UNDERLINE, fontMeta.isUnderline(), false);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_UNDERLINECOLOR, fontMeta.getUnderlineColor(), "");
			}
			formatJSON.put(JSONConstants.FORMAT_FONT, fontJSON);
		}
		json.put(JSONConstants.COMMON_FORMAT, formatJSON);
	}
}
