package com.bokesoft.yes.mid.web.ui.load.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.SlidingPosition;
import com.bokesoft.yigo.common.def.SlidingType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;
import com.bokesoft.yigo.tools.ve.VE;

public class SlidingLayoutPanelJSONBuilder extends BaseComponentJSONBuilder<MetaSlidingLayoutPanel> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaSlidingLayoutPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_SLIDING);
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_STYLE, SlidingType.toString(meta.getStyle()),
				SlidingType.STR_DRAWER);
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_SLIDINGPOSITION,
				SlidingPosition.toString(meta.getSlidingPosition()), SlidingPosition.STR_LEFT);
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_LEFTWIDTH, meta.getLeftWidth()== null ? "" : meta.getLeftWidth().toString(), "");
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_RIGHTWIDTH, meta.getRightWidth() == null ? "" : meta.getRightWidth().toString(), "");
		if (meta.getMainComponent() != null) {
			JSONObject mainJSON = builder.build(ve, builder, metaForm, meta.getMainComponent());
			json.put(JSONConstants.SLIDINGPANEL_MAINPANEL, mainJSON);
		}
		if (meta.getFirstComponent() != null) {
			JSONObject fistJSON = builder.build(ve, builder, metaForm, meta.getFirstComponent());
			json.put(JSONConstants.SLIDINGPANEL_FIRSTPANEL, fistJSON);
		}
		if (meta.getSecondComponent() != null) {
			JSONObject secondJSON = builder.build(ve, builder, metaForm, meta.getSecondComponent());
			json.put(JSONConstants.SLIDINGPANEL_SECONDPANEL, secondJSON);
		}
	}
}
