package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.ProgressIndicatorSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class ProgressIndicatorPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaProgressIndicatorProperties> {
	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaProgressIndicatorProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_SOURCETYPE,
				ProgressIndicatorSourceType.toString(meta.getSourceType()), ProgressIndicatorSourceType.STR_ITEMS);
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDICON, meta.getCompletedIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ATTENTIONICON, meta.getAttentionIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_DEFAULTICON, meta.getDefaultIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR, meta.getUnCompletedLineColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR, meta.getUnCompletedTextColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR, meta.getCompletedLineColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR, meta.getCompletedTextColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ORIENTATION,
				OrientationType.toString(meta.getOrientation()), OrientationType.STR_Horizontal);
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_REVERSEDRAW, meta.isReverseDraw(), false);
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_TITLECOLUMNKEY, meta.getTitleColumnKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY, meta.getMessageColumnKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY, meta.getDateTimeColumnKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ISSCROLL, meta.isScroll(), true);

		JSONArray itemArray = new JSONArray();
		int count = meta.getMetaProgressItemCollection() == null ? 0 : meta.getMetaProgressItemCollection().size();
		for (int i = 0; i < count; i++) {
			MetaProgressItem item = meta.getMetaProgressItemCollection().get(i);
			JSONObject itemObj = new JSONObject();
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_KEY, item.getKey(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_CAPTION, item.getCaption(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.PROGRESSINDICATOR_ITEM_TITLE, item.getTitle(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.PROGRESSINDICATOR_ITEM_MESSAGE, item.getMessage(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.PROGRESSINDICATOR_ITEM_DATETIME, item.getDateTime(), "");
			itemArray.put(itemObj);
		}
		json.put(JSONConstants.PROGRESSINDICATOR_ITEMS, itemArray);
	}
}
