package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class NumberInfoEditorPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaNumberInfoEditorProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaNumberInfoEditorProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NUMBERINFOEDITOR_FORMAT, meta.getEditorFormat(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_IMEOPTIONS, EditorImeOptions.toString(meta.getImeOptions()), "");
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent(), "");
		} 
	}

}
