package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class CheckBoxPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaCheckBoxProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaCheckBoxProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_HIDEBUTTON, meta.getIsHideButton(), false);
	}
}


