package com.bokesoft.yes.mid.web.ui.load.control.listview.extend;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.editview.EditViewJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotator;
import com.bokesoft.yigo.tools.ve.VE;

public class RotatorJSONBuilder extends EditViewJSONBuilder{

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaEditView meta) throws Throwable {
		MetaRotator metaRotator = (MetaRotator)meta;
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INTERVALTIME, metaRotator.getIntervalTime(), 0d);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.GALLERY_REPEAT, metaRotator.isRepeat(), true);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATOR, metaRotator.isIndicator(), true);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATORLOCATION, metaRotator.getIndicatorLocation(), -1);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_PAGINATION, metaRotator.isPagination(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_ANIMTIME, metaRotator.getAnimTime(), 0d);
		return metaJSON;
	}
}
