package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.WebBrowserSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaWebBrowser;
import com.bokesoft.yigo.tools.ve.VE;

public class WebBrowserJSONBuilder extends BaseComponentJSONBuilder<MetaWebBrowser> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaWebBrowser meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.WEBBROWSER_URLPREFIX, meta.getUrlPrefix(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.WEBBROWSER_SOURCETYPE,
				WebBrowserSourceType.format(meta.getSourceType()), WebBrowserSourceType.STR_URL);
		return metaJSON;
	}
}
