package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.ProgressBarStyleType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaProgressBar;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class ProgressBarJSONBuilder extends BaseComponentJSONBuilder<MetaProgressBar> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaProgressBar meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_MAXPOS, meta.getMaxPos(),
				MetaProgressBarProperties.DEFAULT_MAX_POS);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_MINPOS, meta.getMinPos(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_DYNAMIC, meta.isDynamic(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue(),
				MetaProgressBarProperties.DEFAULT_STEP_VALUE);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_STYLE, meta.getStyle(), ProgressBarStyleType.Horizontal);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.PROGRESSBAR_REPEAT, meta.isRepeat(), false);
		return metaJSON;
	}

}
