package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumn;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class DictViewJSONBuilder extends BaseComponentJSONBuilder<MetaDictView> {
	
	@Override
	public JSONObject getMetaJSON(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaDictView meta) throws Throwable {
		JSONObject json = super.getMetaJSON(ve, builder, metaForm, meta);
		
		json.put(JSONConstants.DICTVIEW_FORMULAITEMKEY, meta.getFormulaItemKey());
		json.put(JSONConstants.DICTVIEW_PAGEROWCOUNT, meta.getPageRowCount());
		
		MetaBaseScript rowClick = meta.getRowClick();
		if(rowClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent(), "");
		}
		
		MetaBaseScript rowDblClick = meta.getRowDblClick();
		if(rowDblClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, rowDblClick.getContent(), "");
		}
		
		MetaBaseScript focusRowChanged = meta.getFocusRowChanged();
		if(focusRowChanged != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, focusRowChanged.getContent(), "");
		}
		
		if(meta.getFilters() != null && !meta.getFilters().isEmpty()){
			JSONObject filters = builder.build(ve, builder, metaForm, meta.getFilters());
			json.put(JSONConstants.DICT_ITEMFILTERS, filters);	
			
			//添加依赖
			for(MetaItemFilter itemFilter : meta.getFilters()){
				for(MetaFilter filter : itemFilter){
					builder.addRelations(meta.getKey(),filter.getDependedFields());
				}
			}
		}
		
		MetaDictViewColumnCollection dvCols= meta.getColumnCollection();
		if (dvCols != null && dvCols.size() > 0) {
			JSONArray columns = new JSONArray();
			JSONObject column = null;
			String caption = null;
			DefSize width = null;
			for (MetaDictViewColumn col : dvCols) {
				column = new JSONObject();
				column.put(JSONConstants.COMMON_KEY, col.getKey());
				caption = MetaUtil.getFormLocaleString(ve.getMetaFactory(), ve.getEnv().getLocale(), metaForm.getKey(), GroupKeyTable.STR_DICTVIEWCOLUMN, col.getKey(), col.getCaption());
				column.put(JSONConstants.COMMON_CAPTION, caption);
				width = col.getWidth();
				if (width != null) {
					column.put(JSONConstants.COMMON_WIDTH, col.getWidth().toString());
				}
				columns.put(column);
			}
			json.put(JSONConstants.DICTVIEW_COLUMNS, columns);
		}
		return json;
	}

}
