package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaAttachment;
import com.bokesoft.yigo.tools.ve.VE;

public class AttachmentJSONBuilder extends BaseComponentJSONBuilder<MetaAttachment> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaAttachment meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ATTACHMENT_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ATTACHMENT_MAXSIZE, meta.getMaxSize(), -1);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ATTACHMENT_ALLOWEDTYPES, meta.getAllowedTypes(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ATTACHMENT_PREVIEW, meta.isPreview(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ATTACHMENT_PROVIDER, meta.getProvider(), "");
		return metaJSON;
	}

}
