package com.bokesoft.yes.mid.web.ui.load.anim;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.AnimInterpolatorType;
import com.bokesoft.yigo.common.def.AnimRepeatType;
import com.bokesoft.yigo.common.def.LayoutAnimOrderType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.anim.MetaAnimProperty;
import com.bokesoft.yigo.tools.ve.VE;

public class AnimItemJSONBuilder extends AbstractJSONBuilder<MetaAnimItem> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaAnimItem meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_DURATION, meta.getDuration(), -1L);
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_MAXDURATION, meta.getMaxDuration(), -1L);
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_REPEATMODE, AnimRepeatType.toString(meta.getRepeatMode()), "");
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_REPEATCOUNT, TypeConvertor.toString(meta.getRepeatCount()), "");
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_STARTOFFSET, meta.getStartOffset(), -1L);
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_FILLAFTER, TypeConvertor.toString(meta.getFillAfter()), "");
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_FILLBEFORE, TypeConvertor.toString(meta.getFillBefore()), "");
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_INTERPOLATOR, meta.getInterpolator(), AnimInterpolatorType.ACCELERATE_DECELERATE);
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUTANIM_DELAY, meta.getDelay() + "", "");
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUTANIM_ORDER, meta.getOrder(), LayoutAnimOrderType.NORMAL);
		if (meta.getProperties() != null && meta.getProperties().size() > 0) {
			JSONArray array = new JSONArray();
			for (int i = 0; i < meta.getProperties().size(); i++) {
				MetaAnimProperty property = meta.getProperties().get(i);
				JSONObject pObject = new JSONObject();
				pObject.put(JSONConstants.COMMON_KEY, property.getKey());
				pObject.put(JSONConstants.COMMON_VALUE, property.getValue());
				
				array.put(pObject);
			}
			json.put("properties", array);
		}
	}

}
