package com.bokesoft.yes.mid.web.ui.load;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaHtmlSection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.tools.ve.VE;

public class BodyJSONBuilder extends AbstractJSONBuilder<MetaBody> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaBody meta) throws Throwable {
		int elementCount = meta.size();
		JSONArray blocks = new JSONArray();
		for (int i = 0; i < elementCount; ++i) {
			MetaComponent metaObject = meta.get(i);
			if (metaObject instanceof MetaBlock) {
				MetaBlock metaBlock = (MetaBlock) metaObject;
				JSONObject blockJson = builder.build(ve, builder, metaForm, metaBlock);
				MetaComponent rootComponent = metaBlock.getRoot();
				JSONObject rootPanelJson = builder.build(ve, builder, metaForm, rootComponent);
				blockJson.put(JSONConstants.BODY_ROOT, rootPanelJson);
				blocks.put(blockJson);
			} else if (metaObject instanceof MetaHtmlSection) {
				JSONObject htmlSectionModel = builder.build(ve, builder, metaForm, metaObject);
				json.put(JSONConstants.BODY_HTML, htmlSectionModel);
			}
		}
		json.put(JSONConstants.COMMON_ITEMS, blocks);
		json.put(JSONConstants.BODY_INDEX_OF_BLOCK, 0);
		json.put(JSONConstants.BODY_ISRESIZABLE, meta.isResizable());
		json.put(JSONConstants.BODY_LAZYCOMPUTE, meta.isLazyCompute());

		if (meta.getViewCollection() != null && meta.getViewCollection().size() > 0) {
			json.put("viewCollection", builder.build(ve, builder, metaForm, meta.getViewCollection()));
		}
	}

}