package com.bokesoft.yes.mid.web.ui;

import java.util.HashMap;
import java.util.Map;

import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.ButtonPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.CheckBoxPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.CheckListBoxPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.ComboBoxPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.CountDownViewPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.DatePickerPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.DateRangePickerPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.DictPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.DynamicDictPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.HyperLinkPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.IconPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.ImageListPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.ImagePropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.LabelPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.MonthPickerPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.NumberEditorPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.NumberInfoEditorPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.ScoreBarPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.SearchBoxPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.SegmentedControlPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.SliderPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.SwitchPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.TextAreaPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.TextButtonPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.TextEditorPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.TimePickerPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.UTCDatePickerPropertiesJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.properties.UploadButtonPropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class PropertiesJSONBuilderMap {
	private static Map<Integer, PropertiesJSONBuilder<AbstractMetaObject>> propertiesBuilderMap = null;

	static {
		if (propertiesBuilderMap == null) {
			propertiesBuilderMap = new HashMap<Integer, PropertiesJSONBuilder<AbstractMetaObject>>();
		}
		Object[][] v = new Object[][] { 
				{ ControlType.LABEL, new LabelPropertiesJSONBuilder() },
				{ ControlType.BUTTON, new ButtonPropertiesJSONBuilder() },
				{ ControlType.TEXTEDITOR, new TextEditorPropertiesJSONBuilder() },
				{ ControlType.TEXTBUTTON, new TextButtonPropertiesJSONBuilder() },
				{ ControlType.NUMBEREDITOR, new NumberEditorPropertiesJSONBuilder() },
				{ ControlType.CHECKBOX, new CheckBoxPropertiesJSONBuilder() },
				{ ControlType.DICT, new DictPropertiesJSONBuilder() },
				{ ControlType.DATEPICKER, new DatePickerPropertiesJSONBuilder() },
				{ ControlType.DATERANGEPICKER, new DateRangePickerPropertiesJSONBuilder() },
				{ ControlType.UTCDATEPICKER, new UTCDatePickerPropertiesJSONBuilder() },
				{ ControlType.COMBOBOX, new ComboBoxPropertiesJSONBuilder() },
				{ ControlType.CHECKLISTBOX, new CheckListBoxPropertiesJSONBuilder() },
				{ ControlType.IMAGE, new ImagePropertiesJSONBuilder() },
				{ ControlType.HYPERLINK, new HyperLinkPropertiesJSONBuilder() },
				{ ControlType.DYNAMICDICT, new DynamicDictPropertiesJSONBuilder() },
				{ ControlType.SEARCHBOX, new SearchBoxPropertiesJSONBuilder() },
				{ ControlType.TEXTAREA, new TextAreaPropertiesJSONBuilder() } ,
				{ ControlType.ICON, new IconPropertiesJSONBuilder() } ,
				{ ControlType.SCOREBAR, new ScoreBarPropertiesJSONBuilder() } ,
				{ ControlType.SWITCH, new SwitchPropertiesJSONBuilder() } ,
				{ ControlType.SEGMENTEDCONTROL, new SegmentedControlPropertiesJSONBuilder() } ,
				{ ControlType.NUMBERINFOEDITOR, new NumberInfoEditorPropertiesJSONBuilder() } ,
				{ ControlType.SLIDER, new SliderPropertiesJSONBuilder() }  ,
				{ ControlType.COUNTDOWNVIEW, new CountDownViewPropertiesJSONBuilder() },
				{ ControlType.MONTHPICKER, new MonthPickerPropertiesJSONBuilder() },
				{ ControlType.TIMEPICKER, new TimePickerPropertiesJSONBuilder() },
				{ ControlType.IMAGELIST, new ImageListPropertiesJSONBuilder() },
				{ ControlType.UPLOADBUTTON, new UploadButtonPropertiesJSONBuilder() }
		};
				
				
		int length = v.length;
		for (int i = 0; i < length; ++i) {
			Object[] l = v[i];
			Integer type = (Integer) l[0];
			@SuppressWarnings("unchecked")
			PropertiesJSONBuilder<AbstractMetaObject> action = (PropertiesJSONBuilder<AbstractMetaObject>) l[1];
			propertiesBuilderMap.put(type, action);
		}

	}
	
	public static PropertiesJSONBuilder<AbstractMetaObject> getBuilder(int controlType) {
		return propertiesBuilderMap.get(controlType); 
	}
}
