package com.bokesoft.yes.mid.web.service;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.base.IServiceEnvData;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class ExceptionService extends GeneralService<DefaultContext> {
	private String code = null;
	private String args = null;

	@Override
	public String getServiceName() {
		return "Exception";
	}
	
	@Override
	public void dealWithEnv(DefaultContext context, String cmd, IServiceEnvData data)
			throws Throwable {

	}
	 
	@Override
	public void preProcess(DefaultContext context, String cmd,
			StringHashMap<Object> arguments) throws Throwable {
		super.preProcess(context, cmd, arguments);
	}

	@Override
	public Object process(DefaultContext context, String cmd, StringHashMap<Object> arguments) throws Throwable {
		code = TypeConvertor.toString(arguments.get("code"));
		if (arguments.get("args") != null) {
			args = TypeConvertor.toString(arguments.get("args")); 
		}
		boolean isBPMError = TypeConvertor.toBoolean(arguments.get("isBPMError"));
		String message = null;
		if(isBPMError) {
			message = BPMError.formatMessage(context.getEnv(), Integer.parseInt(code), args);
		} else {
			// TODO:这块需要在客户端处理。message = ViewException.formatMessage(context.getEnv(), Integer.parseInt(code), args);
		}
		return message;
	}
	
	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new ExceptionService();
	}

	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Object[][] getCmdImplTable() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		// TODO Auto-generated method stub
		return null;
	}

}
