package com.bokesoft.yes.mid.web.service;

import java.util.HashMap;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.data.LoadFormDataCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yes.struct.document.DocumentJSONConstants;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveFormData;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.DocumentType;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.usrpara.Paras;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class DealWithDocumentService extends GeneralService<DefaultContext> {

	@Override
	public String getServiceName() {
		return "DealWithDocument";
	}

	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new DealWithDocumentService();
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)DealWithDocumentService.prototype.get(cmd);
	}
	
	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		DealWithDocumentService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(DealWithDocumentService.prototype, new DealWithDocumentService());
	}

	@Override
	protected Object[][] getCmdImplTable() {
		return new Object[][]{
				{ "NewDocument", new NewDocumentImpl() }
//				{ "GetDocument", new GetDocumentImpl() },
//				{ "SaveDocument", new SaveDocumentImpl() }
		};
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return null;
	}
	
	private class NewDocumentImpl extends DefaultServiceCmd {

		private String formKey = null;
		private String templateKey = null;
		
		@Override
		public void dealArguments(DefaultContext context,
				StringHashMap<Object> arguments) throws Throwable {
			formKey = TypeConvertor.toString(arguments.get("formKey"));
			templateKey = TypeConvertor.toString(arguments.get("templateKey"));
			
		}

		@Override
		public Object doCmd(DefaultContext context) throws Throwable {
			Document document = null;
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			
			MetaForm metaForm = null;
			if(templateKey != null && !templateKey.isEmpty()){
				metaForm = metaFactory.getMetaForm(formKey, templateKey);
			}else{
				metaForm = metaFactory.getMetaForm(formKey);
			}
			
			MetaDataSource dataSource = metaForm.getDataSource();
			if (dataSource != null) {
				MetaDataObject dataObject = dataSource.getDataObject();
				if (dataObject != null) {
					document = DocumentUtil.newDocument(dataObject);
				}
			}
			return document;
		}

		@Override
		public IServiceCmd<DefaultContext> newInstance() {
			return new NewDocumentImpl();
		}

		@Override
		public String getCmd() {
			return "NewDocument";
		}
		
		@Override
		public boolean getNeedServiceRight(){
			return true;
		}
		
	}
	
	private class SaveDocumentImpl extends DefaultServiceCmd {

		private JSONObject docJson = null;
		private String formKey = null;
		@Override
		public void dealArguments(DefaultContext context,
				StringHashMap<Object> arguments) throws Throwable {
			docJson = new JSONObject(TypeConvertor.toString(arguments.get("document")));
			formKey = TypeConvertor.toString(arguments.get("formKey"));
		}

		@Override
		public Object doCmd(DefaultContext context) throws Throwable {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
			long OID = JSONHelper.readFromJSON(docJson, DocumentJSONConstants.DOCUMENT_OID, -1);
			Document document = new Document(metaDataObject, OID);
			document.fromJSON(docJson);
			SaveFormData saveData = new SaveFormData(formKey, document);
			Document newDocument = saveData.save(context);
			context.commit();
			return newDocument;
		}

		@Override
		public IServiceCmd<DefaultContext> newInstance() {
			return new SaveDocumentImpl();
		}

		@Override
		public String getCmd() {
			return "ShowDocument";
		}
		
	}
	
	private class GetDocumentImpl extends DefaultServiceCmd {

		private String formKey = null;
		private int operationState = -1;
		private FilterMap filterMap = null;
		private ConditionParas condParameters = null;
		private String parameters = "";
		@Override
		public void dealArguments(DefaultContext context,
				StringHashMap<Object> arguments) throws Throwable {
			formKey = TypeConvertor.toString(arguments.get("formKey"));
			operationState = TypeConvertor.toInteger(arguments.get("operationState"));
			filterMap = new FilterMap();
			filterMap.setOID(TypeConvertor.toLong(arguments.get("OID")));
			String filterMapJSONStr = (String)arguments.get("filterMap");
			if(!filterMapJSONStr.isEmpty()) {
				filterMap.fromJSON(new JSONObject(filterMapJSONStr));
			}

			// 处理查询条件
			String conditions = (String)arguments.get("condition");
			if ( conditions != null && !conditions.isEmpty() ) {
				condParameters = new ConditionParas();
				condParameters.fromJSON(new JSONObject(conditions));
			}
			parameters = (String)arguments.get("parameters");
			
		}

		@Override
		public Object doCmd(DefaultContext context) throws Throwable {

			Paras paras = new Paras();
			JSONObject parasObj = new JSONObject(parameters);
			if(!parasObj.isNull("items")) {
				JSONArray parasArr = parasObj.getJSONArray("items");
				JSONObject para = null;
				for (int i = 0; i < parasArr.length(); i++) {
					para = parasArr.getJSONObject(i);
					paras.put(para.getString("key"), para.get("value"));
				}
			}
			context.setParas(paras);

			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			if (metaDataSource == null) {
				return null;
			}
			
			Document document = null;
			if(operationState == OperationState.New) {
				MetaDataObject metaDataObject = metaDataSource.getDataObject();
				document = DocumentUtil.newDocument(metaDataObject);
				if (metaDataObject.getPrimaryType() == DataObjectPrimaryType.ENTITY && metaDataObject.getMainTable() != null) {
					Long OID = context.applyNewOID();
					document.setOID(OID);
					DataTable mainTable = document.get(metaDataObject.getMainTableKey());
					if (mainTable.first())
						mainTable.setLong(SystemField.OID_SYS_KEY, OID);
				}
				document.setNew();
			} else  {
				int documentType = metaForm.getFormType() == FormType.Detail ? DocumentType.DETAIL : DocumentType.DATAOBJECT;
				filterMap.setType(documentType);
				if (documentType == DocumentType.DETAIL) {
					filterMap.setNeedDocInfo(true);
				}
				LoadFormDataCmd cmd = new LoadFormDataCmd(metaForm.getKey(), filterMap, condParameters);
				document = (Document) cmd.doCmd(context);
				context.getDictCache().preLoadDictCache(metaForm, document);
			} 
			return document;
		}

		@Override
		public IServiceCmd<DefaultContext> newInstance() {
			return new GetDocumentImpl();
		}

		@Override
		public String getCmd() {
			return "GetDocument";
		}
		
	}
}
