package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetSettingCmd extends DefaultServiceCmd {
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSetting setting = metaFactory.getSetting();
		if( setting != null ) {
			return UIJSONHandlerUtil.build(setting, new SolutionSerializeContext(context.getVE()));
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetSettingCmd();
	}
	

	@Override
	public String getCmd() {
		return "GetSetting";
	}

}
