package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetLangConfigCmd extends DefaultServiceCmd {
    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> stringHashMap) throws Throwable {
    }

    @Override
    public Object doCmd(DefaultContext context) throws Throwable {
        MetaLangConfig metaLangConfig = MetaFactory.getGlobalInstance().getSolution().getLangConfig();
        JSONArray configJSON = new JSONArray();
        for (int i = 0; i < metaLangConfig.size(); i++) {
            MetaLang metaLang = metaLangConfig.get(i);
            JSONObject langJSON = new JSONObject();
            langJSON.put("Key", metaLang.getKey());
            langJSON.put("Suffix", metaLang.getSuffix());
            langJSON.put("BaseLang", metaLang.getBaseLang());
            langJSON.put("Description", metaLang.getDescription());
            langJSON.put("WidthMultiple", metaLang.getWidthMultiple());
            langJSON.put("EnableTranslate", metaLang.isEnableTranslate());
            configJSON.put(langJSON);
        }
        return configJSON;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new GetLangConfigCmd();
    }

    @Override
    public String getCmd() {
        return "GetLangConfig";
    }
}
