package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.struct.i18n.I18NInfo;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaEntrySetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class GetEntryCmd extends DefaultServiceCmd {
	
	private String rootEntry = null;
	private String appKey = null;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		rootEntry = (String) arguments.get("rootEntry");
		appKey = (String) arguments.get("appKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		VE ve = context.getVE();
		
		IMetaFactory metaFactory = ve.getMetaFactory();

		MetaEntry metaRoot = null;
		String entryLevelKey = "";

		if(rootEntry != null && !rootEntry.isEmpty()) {
			String[] paths = rootEntry.split("[/]");
			String projectKey = paths[0];
			metaRoot = metaFactory.getMetaEntry(projectKey);
			AbstractCompositeObject obj = null;
			for (int i = 1; i < paths.length; i++) {
				String key = paths[i];
				obj = metaRoot.findChild(key);
				
				if (obj == null) {
					break;
				}
				
				if (obj.getCompositeType() == MetaEntryItem.ENTRY) {
					metaRoot = (MetaEntry) obj;
				} else {
					break;
				}
			}
			entryLevelKey = rootEntry;
		} else {
		    String deftkey = null;
		    if (metaFactory.getSolution().getApps() != null) {
		    	deftkey = metaFactory.getSolution().getApps().getDefaultApp();   
		    }
		    metaRoot = metaFactory.getEntryList(appKey == null ? deftkey :appKey); 
		}
		
		int entryStyle = TreeMenuBarType.GroupTree;
		MetaSetting setting = metaFactory.getSetting();
		if ( setting != null ) {
			MetaEntrySetting entrySetting = setting.getEntry();
			if ( entrySetting != null ) {
				entryStyle = entrySetting.getStyle();
			}
		}
		
		JSONObject jsonObj = new JSONObject();
		toJson(context, metaRoot, jsonObj, entryLevelKey);
		jsonObj.put("style", entryStyle);
		JSONObject result = new JSONObject();
		result.put("entry", jsonObj);

		String locale = context.getEnv().getLocale();
		MetaLang metaLang = context.getVE().getMetaFactory().getSolution().getLangConfig().get(locale);
		String caption = I18NInfo.getInstance().getCaptionString(metaFactory, ve.getEnv().getLocale(), null,
				GroupKeyTable.STR_SOLUTION, metaFactory.getSolution().getKey(), metaFactory.getSolution().getCaption(), metaLang, metaFactory.getSolution());
		result.put("caption", caption);
		result.put("orgCaption", metaFactory.getSolution().getCaption());

		result = AuthorityCheckUtil.getEntry(context, result);
		return result;
	}
	
	private void toJson(DefaultContext defaultContext, MetaEntry metaRoot,
			JSONObject rootModel, String entryLevelKey) throws Throwable {
		if (metaRoot != null) {
			MetaEntry metaEntry = null;
			MetaEntryItem metaEntryItem = null;
			JSONArray jsonArray = new JSONArray();
			for (int i = 0; i < metaRoot.size(); i++) {
				AbstractCompositeObject child = metaRoot.get(i);
				int type = child.getCompositeType();
				if( type == MetaEntryItem.ENTRY ) {
					metaEntry = (MetaEntry) child;
					String newEntryLevelKey = "";
					if (entryLevelKey.isEmpty()) {
						newEntryLevelKey = metaEntry.getProject() + "/" + metaEntry.getKey();
					} else {
						newEntryLevelKey = entryLevelKey + "/" + metaEntry.getKey();
					}
					JSONObject jsonObj = new JSONObject();
					jsonObj.put("key", metaEntry.getKey());
					String locale = defaultContext.getEnv().getLocale();
					MetaLang metaLang = defaultContext.getVE().getMetaFactory().getSolution().getLangConfig().get(locale);
					String caption = I18NInfo.getInstance().getCaptionString(defaultContext.getVE().getMetaFactory(), locale, metaEntry.getProject(),
							GroupKeyTable.STR_ENTRY, newEntryLevelKey.replace('/', '_'), metaEntry.getCaption(), metaLang, metaEntry);
					jsonObj.put("name", caption);
					jsonObj.put("orgCaption", metaEntry.getCaption());
					jsonObj.put("objectType", type);
					jsonObj.put("icon", metaEntry.getIcon());
					jsonObj.put("iconCode", metaEntry.getIconCode());
					boolean calcedVisible = true;
					jsonObj.put("open", metaEntry.isOpen());
					if(metaEntry.getVisible().length() > 0) {
						calcedVisible = TypeConvertor.toBoolean(defaultContext.getMidParser().eval(ScriptType.Formula, metaEntry.getVisible()));
					}
					jsonObj.put("calcedVisible", calcedVisible);
					jsonObj.put("visible", metaEntry.getVisible());
					jsonObj.put("path", newEntryLevelKey);
					jsonObj.put("onClick", metaEntry.getOnClick() == null ? "" : metaEntry.getOnClick().getContent());
					jsonObj.put("project", metaEntry.getProject());
					jsonObj.put("style", metaEntry.getStyle());
					toJson(defaultContext, metaEntry, jsonObj, newEntryLevelKey);
					jsonArray.put(jsonObj);
				} else {
					metaEntryItem = (MetaEntryItem) child;
					String newEntryLevelKey = entryLevelKey + "/" + metaEntryItem.getKey();
					if (entryLevelKey.isEmpty()) {
						newEntryLevelKey = metaEntryItem.getProject() + "/" + metaEntryItem.getKey();
					} else {
						newEntryLevelKey = entryLevelKey + "/" + metaEntryItem.getKey();
					}
					
					JSONObject jsonObj = new JSONObject();
					jsonObj.put("key", metaEntryItem.getKey());
					String locale = defaultContext.getEnv().getLocale();
					MetaLang metaLang = defaultContext.getVE().getMetaFactory().getSolution().getLangConfig().get(locale);
					String caption = I18NInfo.getInstance().getCaptionString(defaultContext.getVE().getMetaFactory(), locale, metaEntryItem.getProject(),
						GroupKeyTable.STR_ENTRY, newEntryLevelKey.replace('/', '_'), metaEntryItem.getCaption(), metaLang, metaEntryItem);
					jsonObj.put("name", caption);
					jsonObj.put("orgCaption", metaEntryItem.getCaption());
					jsonObj.put("objectType", type);
					jsonObj.put("icon", metaEntryItem.getIcon());
					jsonObj.put("iconCode", metaEntryItem.getIconCode());
					jsonObj.put("formKey", metaEntryItem.getFormKey());
					jsonObj.put("action", metaEntryItem.getAction() == null ? "" : metaEntryItem.getAction().getContent());
					boolean calcedEnable = true;
					if(metaEntryItem.getEnable().length() > 0) {
						calcedEnable = TypeConvertor.toBoolean(defaultContext.getMidParser().eval(ScriptType.Formula, metaEntryItem.getEnable()));
					}
					jsonObj.put("calcedEnable", calcedEnable);
					jsonObj.put("enable", metaEntryItem.getEnable());
					jsonObj.put("shortKeys", metaEntryItem.getShortKeys());
					jsonObj.put("type", metaEntryItem.getType());
					boolean calcedVisible = true;
					if(metaEntryItem.getVisible().length() > 0) {
						calcedVisible = TypeConvertor.toBoolean(defaultContext.getMidParser().eval(ScriptType.Formula, metaEntryItem.getVisible()));
					}
					jsonObj.put("calcedVisible", calcedVisible);
					jsonObj.put("visible", metaEntryItem.getVisible());
					jsonObj.put("parameters", metaEntryItem.getParameters());
					jsonObj.put("single", metaEntryItem.isSingle());
					jsonObj.put("target", metaEntryItem.getTarget());
					jsonObj.put("path", newEntryLevelKey);
					jsonObj.put("appKey", defaultContext.getVE().getMetaFactory().getSolution().getKey());
					jsonObj.put("onClick", metaEntryItem.getOnClick() == null ? "" : metaEntryItem.getOnClick().getContent());
					jsonObj.put(JSONConstants.COMMON_TCODE, metaEntryItem.getTCode());
					jsonArray.put(jsonObj);
				}
			}
			
			rootModel.put("children", jsonArray);
		}
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetEntryCmd();
	}

	@Override
	public String getCmd() {
		return "GetEntry";
	}
	
}
