package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetDataObjectKeyCmd extends DefaultServiceCmd {

	private String formKey = "";
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		if(metaForm != null){
			String refDataObjectKey = metaForm.getDataSource().getRefObjectKey();
			if (refDataObjectKey != null && !refDataObjectKey.isEmpty()) {
				return refDataObjectKey;
			}
			
			MetaDataObject dataObj = metaForm.getDataSource().getDataObject();
			if(dataObj != null){
				return dataObj.getKey();
			}
		}
		return "";
	}

	@Override
	public String getCmd() {
		// TODO Auto-generated method stub
		return "GetDataObjectKey";
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetDataObjectKeyCmd();
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
