package com.bokesoft.yes.mid.web.cmd;	

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetDataObjectCmd extends DefaultServiceCmd {

	private String dataObjectKey = "";
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		dataObjectKey = (String) arguments.get("key");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
		if(dataObject == null){
			throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), dataObjectKey));
		}
		return UIJSONHandlerUtil.build(dataObject, new SolutionSerializeContext(context.getVE()));
	}

	@Override
	public String getCmd() {
		return "GetDataObject";
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetDataObjectCmd();
	}
	
	@Override
	public String getCmdId(DefaultContext context, StringHashMap<Object> arguments) throws Throwable{
		String cmdId = "";
		try{			
			//有itemKey 优先处理itemKey 字典相关服务 itemKey 与 formKey都会传递
			String dataObjectKey = (String) arguments.get("key");
			
			if(dataObjectKey != null && !dataObjectKey.isEmpty()){
				MetaDataObject metaDataObj = context.getVE().getMetaFactory().getDataObject(dataObjectKey);
				if(metaDataObj != null){
					String projectKey = metaDataObj.getProject().getKey();
					cmdId = projectKey + "/" + dataObjectKey;
					return cmdId;
				}
			}
			
		}catch(Throwable e){
			LogSvr.getInstance().error("getCmdId has error.", e);
			cmdId = "";
		}
		return cmdId;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
