package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.struct.PairItemList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetCondSignItemsCmd extends DefaultServiceCmd{
	private String formKey = "";
	private String field = "";
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
		field = (String) arguments.get("field");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
		
		PairItemList result = new PairItemList();
		int controlType = -1;
		if (metaForm != null) {				
			MetaComponent meta = metaForm.componentByKey(field);
			if(meta != null){
				controlType = meta.getControlType();
			}else {
				MetaGridCell metaCell = metaForm.metaGridCellByKey(field);
				controlType = metaCell.getCellType();
			}				
		}
		
		// 根据控件类型返回节点列表
		switch (controlType) {
		case ControlType.TEXTEDITOR:
			result.add(CondSign.NONE, "");
			result.add(CondSign.EQ,CondSign.S_EQ);
			result.add(CondSign.LIKE, CondSign.S_LIKE);
			break;
		case ControlType.NUMBEREDITOR:
			result.add(CondSign.NONE, "");
			result.add(CondSign.EQ, CondSign.S_EQ);
			result.add(CondSign.GT, CondSign.S_GT);
			result.add(CondSign.GT_EQ, CondSign.S_GT_EQ);
			result.add(CondSign.LT, CondSign.S_LT);
			result.add(CondSign.LT_EQ, CondSign.S_LT_EQ);
			result.add(CondSign.NEQ, CondSign.S_NEQ);
			//result.add(CondSign.IN, CondSign.S_IN);	
			break;
		case ControlType.DATEPICKER:
			result.add(CondSign.NONE, "");
			result.add(CondSign.EQ, CondSign.S_EQ);
			result.add(CondSign.GT, CondSign.S_GT);
			result.add(CondSign.GT_EQ, CondSign.S_GT_EQ);
			result.add(CondSign.LT, CondSign.S_LT);
			result.add(CondSign.LT_EQ, CondSign.S_LT_EQ);
			result.add(CondSign.NEQ, CondSign.S_NEQ);	
			break;
		case ControlType.COMBOBOX:				
		case ControlType.DICT:
			result.add(CondSign.NONE, "");
			result.add(CondSign.EQ, CondSign.S_EQ);
			result.add(CondSign.IN, CondSign.S_IN);	
			break;
		default:
			result.add(CondSign.NONE, "");
			result.add(CondSign.EQ, CondSign.S_EQ);
			result.add(CondSign.GT, CondSign.S_GT);
			result.add(CondSign.GT_EQ, CondSign.S_GT_EQ);
			result.add(CondSign.LT, CondSign.S_LT);
			result.add(CondSign.LT_EQ, CondSign.S_LT_EQ);
			result.add(CondSign.NEQ, CondSign.S_NEQ);
			result.add(CondSign.LIKE, CondSign.S_LIKE);
			result.add(CondSign.IN, CondSign.S_IN);				
		}			
		return result.toJSON().get("items");
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetCondSignItemsCmd();
	}

	@Override
	public String getCmd() {
		return "GetCondSignItems";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
