package com.bokesoft.yes.mid.web.cmd;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.app.MetaClientAppDef;
import com.bokesoft.yigo.meta.app.MetaClientAppStatusInfo;
import com.bokesoft.yigo.meta.app.MetaClientAppStatusInfoItem;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetClientAppStatusInfoCmd extends DefaultServiceCmd {

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {

		JSONArray statusArr = new JSONArray();
		MetaClientAppDef clientAppDef = context.getVE().getMetaFactory().getClientAppDef();
		if (clientAppDef != null) {
			MetaClientAppStatusInfo statusInfo = clientAppDef.getStatusInfo();
			if (statusInfo != null && !statusInfo.empty()) {
				Iterator<MetaClientAppStatusInfoItem> it = statusInfo.iterator();
				MetaClientAppStatusInfoItem statusInfoItem = null;
				
				JSONObject status = null;
				while (it.hasNext()) {
					status = new JSONObject();
					statusInfoItem = it.next();

					status.put("key", statusInfoItem.getKey());
					status.put("caption", statusInfoItem.getCaption());
					status.put("formula", statusInfoItem.getFormulaCaption());
					statusArr.put(status);
				}
			}
		}
		return statusArr;
	}

	@Override
	public String getCmd() {
		return "GetClientAppStatusInfo";
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetClientAppStatusInfoCmd();
	}

}
