package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.MetaProcessJsonSerializer;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetBPMProcessCmd extends DefaultServiceCmd{
	private String formKey = "";
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MidVEHost veHost = new MidVEHost(context);
		IMetaFactory factory = veHost.getVE().getMetaFactory();
		MetaProcessMap pm = factory.getMetaBPM().getMetaProcessMapCollection().getDataobjectMapInfo(metaForm.getDataSource().getDataObject().getRelateObjectKey());
		if (pm != null) {
			String processKey = pm.getProcessKey();
			MetaProcess process = factory.getProcessDefinationByDeployKey(processKey);
			if (process != null) {
				MetaProcessJsonSerializer serializer = new MetaProcessJsonSerializer(process, veHost);
				return serializer.serialize();
			}
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetBPMProcessCmd();
	}

	@Override
	public String getCmd() {
		return "GetBPMProcess";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}

}

