/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.auth;

import com.bokesoft.yes.common.encrypt.SaltHash;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.mid.auth.LoginImpl;
import com.bokesoft.yes.mid.auth.LoginUtil;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.certificate.utils.MidPasswordRuleChecker;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.session.ISessionLog;
import com.bokesoft.yes.mid.session.SysSessionLog;
import com.bokesoft.yes.mid.session.UserRoleUtil;
import com.bokesoft.yes.mid.util.AuthUtil;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.auth.IAuthLogProcess;
import com.bokesoft.yigo.mid.auth.ILoginProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.base.LoginInfo;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.mid.rsa.RSAMidUtil;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class Login {
    private String SQL_QUERY_USER = null;
    private LoginInfo loginInfo = null;
    protected Long operatorID = null;
    protected String name = "";
    protected String passwordFromDB = "";
    protected ISessionLog sessionLog = new SysSessionLog();
    protected IAccountLockoutInfoMap accountLockoutInfoMap = null;
    protected ILoginProcess<IServiceContext> loginProcess = null;
    private LoginImpl impl = null;
    private static ServiceLoader<IAuthLogProcess> authLogProcesses = ServiceLoader.load(IAuthLogProcess.class);

    public Login(LoginInfo loginInfo) {
        this.loginInfo = loginInfo;
        this.impl = new LoginImpl(loginInfo);
    }

    protected void checkValidateCode(DefaultContext defaultContext) {
        ISessionInfo iSessionInfo;
        if (ServerSetting.getInstance().containsValidateLevel(1) && ((iSessionInfo = SessionInfoProviderHolder.getProvider((int)0).getSessionInfoMap().get(this.loginInfo.getTempClientID())) == null || !iSessionInfo.getValidateCode().equalsIgnoreCase(this.loginInfo.getValidateCode()))) {
            throw new SessionException(8, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)8, (Object[])new Object[0]));
        }
    }

    private JSONObject doLoginImpl(DefaultContext defaultContext) throws Throwable {
        Object object;
        Object object2;
        if (this.loginInfo.getUser().equalsIgnoreCase("Guest")) {
            throw new SessionException(16, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)16, (Object[])new Object[0]));
        }
        int n2 = this.loginInfo.getMode();
        ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n2);
        if (iSessionInfoProvider == null) {
            throw new SessionException(5, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)5, (Object[])new Object[0]));
        }
        this.checkValidateCode(defaultContext);
        MidVE midVE = defaultContext.getVE();
        this.initSQLQuery(defaultContext);
        this.queryUserData(defaultContext);
        Env env = defaultContext.getVE().getEnv();
        String string = env.getClientID();
        env.setUserID(this.operatorID);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setClientID(string);
        sessionInfo.setOperatorID(this.operatorID);
        sessionInfo.setUserCode(this.loginInfo.getUser());
        sessionInfo.setIP(env.getClientIP());
        sessionInfo.setLoginTime(DateUtil.getNowTime());
        sessionInfo.setLastActiveTime(DateUtil.getNowTime());
        sessionInfo.setMode(n2);
        sessionInfo.setSessionParas(this.loginInfo.getParas());
        sessionInfo.setUserName(this.name);
        this.queryRoleData(defaultContext, sessionInfo, this.operatorID);
        try {
            this.accountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
            this.accountLockoutInfoMap.autoUnlock(defaultContext, (ISessionInfo)sessionInfo);
            this.accountLockoutInfoMap.check(defaultContext, (ISessionInfo)sessionInfo);
            this.passwordCheck(defaultContext);
        }
        catch (CoreException coreException) {
            this.sessionLog.logErr(defaultContext, -2, coreException.getMessage());
            throw coreException;
        }
        env.setUserName(this.name);
        env.setAuthenticated(true);
        Iterator<IAuthLogProcess> iterator = sessionInfo.getSessionParas().get("kick");
        if (iterator != null) {
            SvrInfo.setKick((boolean)((Boolean)((Object)iterator)));
        }
        if (SvrInfo.kick() && (iterator = AuthUtil.getOperatorClientIds((String)String.valueOf(this.operatorID))).size() > 0) {
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                ISessionInfo iSessionInfo = iSessionInfoProvider.getSessionInfoMap().get((String)object);
                if (iSessionInfo == null) continue;
                this.sessionLog.logKickout((VE)midVE, this.operatorID.longValue());
                iSessionInfoProvider.getSessionInfoMap().remove((String)object);
                AuthUtil.putKickInfo((String)(this.operatorID + "@" + (String)object), (String)object);
                if (this.loginProcess != null) {
                    this.loginProcess.kickout((IServiceContext)defaultContext);
                }
                iterator = authLogProcesses.iterator();
                while (iterator.hasNext()) {
                    iterator.next().postKickout(defaultContext, this.loginInfo, iSessionInfo);
                }
            }
        }
        iterator = new JSONObject();
        iterator.put("clientID", string);
        iterator.put("UserID", this.operatorID);
        iterator.put("Time", sessionInfo.getLoginTime().getTime());
        iterator.put("Name", this.name);
        this.impl.doLoginImpl(defaultContext, sessionInfo);
        this.sessionLog.logLogin(defaultContext, (ISessionInfo)sessionInfo);
        int n3 = this.accountLockoutInfoMap.log(defaultContext, this.operatorID.longValue(), sessionInfo.getMode(), 0);
        LoginUtil.removeTempSessionInfo(this.loginInfo.getTempClientID());
        object2 = env.getSessionParas();
        object = env.getClusterid();
        iterator.put("SessionParas", object2 == null ? "" : JSONUtil.toJSON((Map)object2));
        iterator.put("clusterID", object);
        iterator.put("LoginCount", n3);
        return iterator;
    }

    private JSONObject doLoginCheckImpl(DefaultContext object) throws Throwable {
        if (this.loginInfo.getUser().equalsIgnoreCase("Guest")) {
            throw new SessionException(16, SessionException.formatMessage((ILocale)object.getEnv(), (int)16, (Object[])new Object[0]));
        }
        int n2 = this.loginInfo.getMode();
        ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n2);
        if (iSessionInfoProvider == null) {
            throw new SessionException(5, SessionException.formatMessage((ILocale)object.getEnv(), (int)5, (Object[])new Object[0]));
        }
        this.checkValidateCode((DefaultContext)object);
        this.initSQLQuery((DefaultContext)object);
        this.queryUserData((DefaultContext)object);
        Env env = object.getVE().getEnv();
        Object object2 = env.getClientID();
        env.setUserID(this.operatorID);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setClientID((String)object2);
        sessionInfo.setOperatorID(this.operatorID);
        sessionInfo.setIP(env.getClientIP());
        sessionInfo.setLoginTime(DateUtil.getNowTime());
        sessionInfo.setLastActiveTime(DateUtil.getNowTime());
        sessionInfo.setMode(n2);
        sessionInfo.setSessionParas(this.loginInfo.getParas());
        this.queryRoleData((DefaultContext)object, sessionInfo, this.operatorID);
        try {
            this.accountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
            this.accountLockoutInfoMap.autoUnlock((DefaultContext)object, (ISessionInfo)sessionInfo);
            this.accountLockoutInfoMap.check((DefaultContext)object, (ISessionInfo)sessionInfo);
            this.passwordCheck((DefaultContext)object);
        }
        catch (CoreException coreException) {
            this.sessionLog.logErr((DefaultContext)object, -2, coreException.getMessage());
            throw coreException;
        }
        env.setUserName(this.name);
        env.setAuthenticated(true);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("kick", false);
        object = AuthUtil.getOperatorClientIds((String)String.valueOf(this.operatorID));
        if (object.size() > 0) {
            env = new JSONArray();
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                object = iSessionInfoProvider.getSessionInfoMap().get((String)object);
                if (object == null) continue;
                object = new JSONObject(object);
                env.put(object);
            }
            if (env.length() > 0) {
                jSONObject.put("SessionInfo", (Object)env);
            }
            jSONObject.put("kick", true);
        }
        return jSONObject;
    }

    public final JSONObject doLogin(DefaultContext defaultContext) throws Throwable {
        Object object = defaultContext.getVE();
        object.setAuthenticate(true);
        Object object2 = defaultContext.getVE().getMetaFactory().getSetting();
        if (object2 != null && (object2 = object2.getLogin()) != null && (object2 = object2.getLoginProcess()) != null && !((String)object2).isEmpty()) {
            this.loginProcess = (ILoginProcess)ReflectHelper.newInstance((VE)object, (String)object2);
        }
        if (this.loginProcess != null) {
            this.loginProcess.before((IServiceContext)defaultContext, this.loginInfo);
        }
        try {
            object2 = this.doLoginImpl(defaultContext);
            object = object.getEnv().getClientID();
            AuthUtil.putOperator4ClientIdCache((String)String.valueOf(this.operatorID), (String)object);
        }
        catch (Exception exception) {
            if (this.loginProcess != null) {
                this.loginProcess.failed((IServiceContext)defaultContext, this.loginInfo, exception);
            }
            throw exception;
        }
        if (this.loginProcess != null) {
            this.loginProcess.success((IServiceContext)defaultContext, this.loginInfo);
        }
        return object2;
    }

    public final JSONObject doLoginCheck(DefaultContext defaultContext) throws Throwable {
        MidVE midVE = defaultContext.getVE();
        midVE.setAuthenticate(true);
        Object object = defaultContext.getVE().getMetaFactory().getSetting();
        if (object != null && (object = object.getLogin()) != null && (object = object.getLoginProcess()) != null && !((String)object).isEmpty()) {
            this.loginProcess = (ILoginProcess)ReflectHelper.newInstance((VE)midVE, (String)object);
        }
        if (this.loginProcess != null) {
            this.loginProcess.before((IServiceContext)defaultContext, this.loginInfo);
        }
        try {
            object = this.doLoginCheckImpl(defaultContext);
        }
        catch (Exception exception) {
            if (this.loginProcess != null) {
                this.loginProcess.failed((IServiceContext)defaultContext, this.loginInfo, exception);
            }
            throw exception;
        }
        return object;
    }

    private void initSQLQuery(DefaultContext defaultContext) throws Throwable {
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        defaultContext = defaultContext.getDBManager();
        iMetaFactory = (MetaTable)iMetaFactory.getDataObject("Operator").getTableCollection().get("SYS_Operator");
        String string = ((MetaColumn)iMetaFactory.get("Code")).getBindingDBColumnName();
        String string2 = ((MetaColumn)iMetaFactory.get("Enable")).getBindingDBColumnName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(iMetaFactory.getOIDColumn().getBindingDBColumnName());
        arrayList.add(((MetaColumn)iMetaFactory.get("Password")).getBindingDBColumnName());
        arrayList.add(((MetaColumn)iMetaFactory.get("Name")).getBindingDBColumnName());
        this.SQL_QUERY_USER = DBUtil.getQuerySQL((IDBManager)defaultContext, arrayList, (MetaTable)iMetaFactory, (String)string2) + " and " + defaultContext.keyWordEscape(string) + "=?";
    }

    protected void queryUserData(DefaultContext defaultContext) throws Throwable {
        PreparedStatement preparedStatement;
        block6: {
            IDBManager iDBManager = defaultContext.getDBManager();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = iDBManager.preparedQueryStatement(this.SQL_QUERY_USER);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addIntArg(Integer.valueOf(1));
                pSArgs.addStringArg(this.loginInfo.getUser().toUpperCase());
                resultSet = iDBManager.executeQuery(preparedStatement, this.SQL_QUERY_USER, (QueryArguments)pSArgs);
                if (!resultSet.next()) {
                    LoginUtil.recordLoginFailed(this.loginInfo.getTempClientID());
                    this.sessionLog.logErr(defaultContext, 1, "");
                    throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
                }
                this.operatorID = resultSet.getLong(1);
                this.passwordFromDB = resultSet.getString(2);
                this.name = resultSet.getString(3) == null ? "" : resultSet.getString(3);
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    protected void queryRoleData(DefaultContext defaultContext, SessionInfo sessionInfo, Long l2) throws Throwable {
        new UserRoleUtil().queryRoleData(defaultContext, (ISessionInfo)sessionInfo, l2);
    }

    protected void passwordCheck(DefaultContext defaultContext) throws Throwable {
        MetaSetting metaSetting = defaultContext.getVE().getMetaFactory().getSetting();
        boolean bl = metaSetting != null && metaSetting.getLogin() != null && metaSetting.getLogin().getEncryptType() == 2 ? this.hashCheck() : this.RSACheck(defaultContext);
        if (!bl) {
            LoginUtil.recordLoginFailed(this.loginInfo.getTempClientID());
            this.accountLockoutInfoMap.log(defaultContext, this.operatorID.longValue(), this.loginInfo.getMode(), 1);
            this.sessionLog.logErr(defaultContext, 1, "");
            String string = "" + this.operatorID;
            string = this.accountLockoutInfoMap.get(string);
            if (string == null) {
                throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
            }
            int n2 = this.accountLockoutInfoMap.getAccountLockoutThreshold();
            int n3 = string.getLogin_failed_count();
            if ((n3 = n2 - n3) > 0) {
                if (n3 == 1) {
                    throw new SessionException(14, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)14, (Object[])new Object[]{n2}));
                }
                throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
            }
            throw new SessionException(4, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)4, (Object[])new Object[0]));
        }
    }

    private boolean RSACheck(DefaultContext defaultContext) throws Throwable {
        String string = RSAMidUtil.decryptByPrivate((String)SysPara.getInstance().get("PrivateKey"), (String)this.passwordFromDB);
        String string2 = this.loginInfo.getPassword();
        MidPasswordRuleChecker.getInstance().checkLoginRule(string2, defaultContext.getVE().getEnv().getLocale(), (Object)defaultContext);
        return string2.equals(string);
    }

    private boolean hashCheck() throws Throwable {
        return SaltHash.validatePassword((String)this.loginInfo.getPassword(), (String)this.passwordFromDB);
    }
}

