/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.session;

import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.mid.auth.Login;
import com.bokesoft.yigo.mid.auth.Logout;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.LoginInfo;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.session.SessionUtils$IYigoClientContextProvider;
import com.bokesoft.yigo.session.SessionUtils$SSOLogin;
import com.bokesoft.yigo.session.SessionUtils$YigoRunnable;
import com.bokesoft.yigo.session.YigoClientContextWrapper;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.date.ExceptionUtils;

public class SessionUtils {
    private static final Logger log = LoggerFactory.getLogger(SessionUtils.class);
    public static final int LOGIN_MODE_PC = 1;
    public static final int LOGIN_MODE_MOBILE = 2;
    private static final String ENV_TIME_PATTERN = "yyyy/MM/dd HH:mm:ss";

    private SessionUtils() {
    }

    public static String login(String string, String string2, String string3, int n2) {
        return SessionUtils.processWithContext(null, defaultContext -> {
            Env env = defaultContext.getEnv();
            string = string + "-" + UUID.randomUUID().toString();
            env.setClientID(string);
            string3 = string3 == null ? "" : string3;
            string3 = new LoginInfo(string2, string3, -1L, n2, "", null);
            string3 = new Login((LoginInfo)string3);
            try {
                ((Login)((Object)string3)).doLogin(defaultContext);
            }
            catch (Throwable throwable) {
                return (String)ExceptionUtils.rethrow((Throwable)throwable);
            }
            return string;
        });
    }

    public static String loginBackend(String string) {
        return SessionUtils.loginBackend(string, 1);
    }

    /*
     * Loose catch block
     */
    public static String loginBackend(String string, int n2) {
        DefaultContext defaultContext = null;
        defaultContext = ContextBuilder.create();
        string = SessionUtils.loginBackend(defaultContext, string, n2, null);
        defaultContext.commit();
        try {
            defaultContext.close();
        }
        catch (Throwable throwable) {}
        return string;
        catch (Throwable throwable) {
            String string2;
            try {
                try {
                    defaultContext.rollback();
                }
                catch (Throwable throwable2) {}
                string2 = (String)ExceptionUtils.rethrow((Throwable)throwable);
            }
            catch (Throwable throwable3) {
                try {
                    defaultContext.close();
                }
                catch (Throwable throwable4) {}
                throw throwable3;
            }
            try {
                defaultContext.close();
            }
            catch (Throwable throwable5) {}
            return string2;
        }
    }

    public static String loginBackend(DefaultContext defaultContext, String string, int n2, Map<String, Object> map) {
        return SessionUtils.loginBackend(defaultContext, string, null, n2, map);
    }

    public static String loginBackend(DefaultContext defaultContext, String object, String string, int n2, Map<String, Object> map) {
        Env env = defaultContext.getEnv();
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = UUID.randomUUID().toString();
        }
        env.setClientID(string);
        String string2 = (String)map.get("locale");
        if (StringUtils.isBlank((CharSequence)string2)) {
            string2 = DefaultLocale.getDefaultLocale().getLocale();
        }
        env.setLocale(string2);
        object = new LoginInfo((String)object, "", -1L, n2, "", new HashMap<String, Object>(map));
        object = new SessionUtils$SSOLogin((LoginInfo)object);
        try {
            defaultContext = ((Login)object).doLogin(defaultContext);
            long l2 = defaultContext.getLong("UserID");
            SessionUtils.wrapEnvSetUserID(env, l2);
            object = defaultContext.getString("Name");
            env.setUserName((String)object);
            long l3 = defaultContext.getLong("Time");
            env.setTime(DateFormatUtils.format((Date)new Date(l3), (String)ENV_TIME_PATTERN));
            env.setMode(n2);
            return string;
        }
        catch (Throwable throwable) {
            return (String)ExceptionUtils.rethrow((Throwable)throwable);
        }
    }

    private static void wrapEnvSetUserID(Env env, long l2) {
        env.getUserID();
        env.setUserID(Long.valueOf(l2));
    }

    public static boolean attachSession(DefaultContext defaultContext, String string) {
        return SessionUtils.attachSession(defaultContext, string, 1);
    }

    public static boolean attachSession(DefaultContext defaultContext, String string, int n2) {
        defaultContext = defaultContext.getEnv();
        if ((string = SessionUtils.getLoginSession(string)) != null) {
            defaultContext.setClientID(string.getClientID());
            defaultContext.setClientIP(string.getIP());
            defaultContext.setClusterid(string.getClusterID());
            defaultContext.setGuestUserID(string.getGuestUserID());
            defaultContext.setMode(string.getMode());
            defaultContext.setSessionParas(string.getSessionParas());
            defaultContext.setTicketID(string.getTicketID());
            SessionUtils.wrapEnvSetUserID((Env)defaultContext, string.getOperatorID());
            defaultContext.setRoleIDList((List)string.getRoleIDList());
            defaultContext.setMode(n2);
            defaultContext.setSessionParas(string.getSessionParas());
            return true;
        }
        return false;
    }

    public static boolean attachBackgroundSession(DefaultContext defaultContext, String string) {
        return SessionUtils.attachBackgroundSession(defaultContext, string, 1);
    }

    public static boolean attachBackgroundSession(DefaultContext object, String string, int n2) {
        Env env = object.getEnv();
        object = object.getDictCache();
        try {
            object = object.locate("Operator", "Code", (Object)string, null, null, 7, null, null, 0);
        }
        catch (Throwable throwable) {
            return (Boolean)ExceptionUtils.rethrow((Throwable)throwable);
        }
        if (object != null) {
            object = object.getID();
            env.setClientID("BG-" + UUID.randomUUID());
            SessionUtils.wrapEnvSetUserID(env, (Long)object);
            env.setUserCode(string);
            env.setMode(1);
            return true;
        }
        return false;
    }

    public static ISessionInfo getLoginSession(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        ISessionInfo iSessionInfo = SessionInfoProviderHolder.getProvider((int)1).getSessionInfoMap().get(string);
        if (iSessionInfo == null) {
            iSessionInfo = SessionInfoProviderHolder.getProvider((int)2).getSessionInfoMap().get(string);
        }
        return iSessionInfo;
    }

    public static <T> T processWithContext(String string, SessionUtils$YigoRunnable<T> sessionUtils$YigoRunnable) {
        return SessionUtils.processWithContext(string, null, sessionUtils$YigoRunnable);
    }

    /*
     * Loose catch block
     */
    public static <T> T processWithContext(String string, SessionUtils$IYigoClientContextProvider object, SessionUtils$YigoRunnable<T> sessionUtils$YigoRunnable) {
        DefaultContext defaultContext;
        block16: {
            defaultContext = null;
            if (object == null) {
                defaultContext = ContextBuilder.create();
            } else {
                int n2 = object.getPort();
                object = object.getHost();
                defaultContext = new DefaultContext(new DefaultMidVEFactory((String)object, String.valueOf(n2)).createVE());
            }
            SessionUtils.attachSession(defaultContext, string);
            T t2 = sessionUtils$YigoRunnable.run(defaultContext);
            defaultContext.commit();
            object = t2;
            if (defaultContext == null) break block16;
            try {
                defaultContext.close();
            }
            catch (Throwable throwable) {}
        }
        return (T)object;
        catch (Throwable throwable) {
            block17: {
                try {
                    if (defaultContext != null) {
                        try {
                            defaultContext.rollback();
                        }
                        catch (Throwable throwable2) {}
                    }
                    object = ExceptionUtils.rethrow((Throwable)throwable);
                    if (defaultContext == null) break block17;
                }
                catch (Throwable throwable3) {
                    if (defaultContext != null) {
                        try {
                            defaultContext.close();
                        }
                        catch (Throwable throwable4) {}
                    }
                    throw throwable3;
                }
                try {
                    defaultContext.close();
                }
                catch (Throwable throwable5) {}
            }
            return (T)object;
        }
    }

    /*
     * Loose catch block
     */
    public static <T> T processWithBackgroundContext(String string, SessionUtils$YigoRunnable<T> sessionUtils$YigoRunnable) {
        DefaultContext defaultContext;
        block14: {
            defaultContext = null;
            defaultContext = ContextBuilder.create();
            SessionUtils.attachBackgroundSession(defaultContext, string);
            string = sessionUtils$YigoRunnable.run(defaultContext);
            defaultContext.commit();
            if (defaultContext == null) break block14;
            try {
                defaultContext.close();
            }
            catch (Throwable throwable) {}
        }
        return (T)string;
        catch (Throwable throwable) {
            Object object;
            block15: {
                try {
                    if (defaultContext != null) {
                        try {
                            defaultContext.rollback();
                        }
                        catch (Throwable throwable2) {}
                    }
                    object = ExceptionUtils.rethrow((Throwable)throwable);
                    if (defaultContext == null) break block15;
                }
                catch (Throwable throwable3) {
                    if (defaultContext != null) {
                        try {
                            defaultContext.close();
                        }
                        catch (Throwable throwable4) {}
                    }
                    throw throwable3;
                }
                try {
                    defaultContext.close();
                }
                catch (Throwable throwable5) {}
            }
            return (T)object;
        }
    }

    public static String ssoLogin(String string, Map<String, Object> map, YigoClientContextWrapper yigoClientContextWrapper) {
        if ((string = SessionUtils.processWithContext(null, yigoClientContextWrapper, defaultContext -> {
            try {
                return SessionUtils.loginBackend(defaultContext, string, null, 1, map);
            }
            catch (Exception exception) {
                log.error("SSO \u767b\u5f55\u5931\u8d25: userCode='{}', params='{}', \u9519\u8bef\u4fe1\u606f: {}", new Object[]{string, map, exception.getMessage()});
                return (String)ExceptionUtils.rethrow((Throwable)exception);
            }
        })) != null) {
            yigoClientContextWrapper.doAfterLogin(string);
        }
        return string;
    }

    public static void logout(String string) {
        SessionUtils.processWithContext(string, defaultContext -> {
            new Logout().doLogout(defaultContext);
            return Boolean.FALSE;
        });
    }
}

