/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.template;

import com.bokesoft.yes.report.template.ReportCell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReportRow {
    private int type = -1;
    private int height = 0;
    private String tableKey = "";
    private String backColor = "";
    private boolean lineBreak = false;
    private boolean pageBreak = false;
    private String groupKey = "";
    private int groupLevel = -1;
    private boolean groupHead = false;
    private ArrayList<ReportCell> cellArray = new ArrayList();
    private int dtlCountEveryPage = 0;
    private String filter = "";

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTableKey(String string) {
        this.tableKey = string;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public void setLineBreak(boolean bl) {
        this.lineBreak = bl;
    }

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public boolean isPageBreak() {
        return this.pageBreak;
    }

    public void setPageBreak(boolean bl) {
        this.pageBreak = bl;
    }

    public void setGroupKey(String string) {
        this.groupKey = string;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupLevel(int n) {
        this.groupLevel = n;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public void setGroupHead(boolean bl) {
        this.groupHead = bl;
    }

    public boolean isGroupHead() {
        return this.groupHead;
    }

    public void addCell(ReportCell reportCell) {
        this.cellArray.add(reportCell);
    }

    public int getCellCount() {
        return this.cellArray.size();
    }

    public ReportCell getCell(int n) {
        return this.cellArray.get(n);
    }

    public void replace(int n, int n2, List<ReportCell> object) {
        while (n2 > 0) {
            this.cellArray.remove(n + n2 - 1);
            --n2;
        }
        n2 = n;
        Iterator<ReportCell> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.cellArray.add(n2, (ReportCell)object);
            ++n2;
        }
    }

    public void setDtlRowCountEveryPage(int n) {
        this.dtlCountEveryPage = n;
    }

    public int getDtlRowCountEveryPage() {
        return this.dtlCountEveryPage;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public boolean isMergedRow() {
        for (ReportCell reportCell : this.cellArray) {
            if (!reportCell.isMergedHead() || reportCell.getMergedRowSpan() <= 1) continue;
            return true;
        }
        return false;
    }

    public int getMergedRowSpan() {
        int n = 1;
        for (ReportCell reportCell : this.cellArray) {
            if (!reportCell.isMergedHead()) continue;
            n = Math.max(n, reportCell.getMergedRowSpan());
        }
        return n;
    }

    public ReportRow clone() {
        ReportRow reportRow = new ReportRow();
        reportRow.setType(this.getType());
        reportRow.setHeight(this.getHeight());
        reportRow.setTableKey(this.getTableKey());
        reportRow.setBackColor(this.getBackColor());
        reportRow.setLineBreak(this.isLineBreak());
        reportRow.setGroupKey(this.getGroupKey());
        reportRow.setGroupLevel(this.getGroupLevel());
        reportRow.setGroupHead(this.isGroupHead());
        reportRow.setDtlRowCountEveryPage(this.getDtlRowCountEveryPage());
        reportRow.setFilter(this.getFilter());
        for (int i = 0; i < this.getCellCount(); ++i) {
            reportRow.addCell(this.getCell(i).clone());
        }
        return reportRow;
    }
}

