/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.report.print.chart.builder.impl;

import com.bokesoft.yes.report.output.OutputEmbedChart;
import com.bokesoft.yigo.report.print.chart.builder.IChartBuilder;
import com.bokesoft.yigo.report.print.chart.util.ReportChartDataUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;

public abstract class AbstractChartBuilder
implements IChartBuilder {
    @Override
    public JFreeChart build(OutputEmbedChart outputEmbedChart) {
        CategoryDataset categoryDataset = this.createCategoryDataset(outputEmbedChart);
        outputEmbedChart = this.createChart(outputEmbedChart.getTitle(), outputEmbedChart.getCategoryAxisTitle(), outputEmbedChart.getSeriesAxisTitle(), categoryDataset);
        ReportChartDataUtils.setDefaultFont((JFreeChart)outputEmbedChart);
        return outputEmbedChart;
    }

    @Override
    public JFreeChart buildDemo() {
        CategoryDataset categoryDataset = this.createCategoryDatasetDemo();
        categoryDataset = this.createChart("Title(\u56fe\u8868\u6807\u9898)", "CategoryAxisTitle(\u9879\u76ee\u8f74\u6807\u9898)", "SeriesAxisTitle(\u7cfb\u5217\u8f74\u6807\u9898)", categoryDataset);
        ReportChartDataUtils.setDefaultFont((JFreeChart)categoryDataset);
        if (categoryDataset.getCategoryPlot().getRenderer() instanceof BarRenderer) {
            ((BarRenderer)categoryDataset.getCategoryPlot().getRenderer()).setItemMargin(0.05);
        }
        return categoryDataset;
    }

    protected CategoryDataset createCategoryDataset(OutputEmbedChart outputEmbedChart) {
        return ReportChartDataUtils.getCategoryDataset(outputEmbedChart);
    }

    protected CategoryDataset createCategoryDatasetDemo() {
        return ReportChartDataUtils.getCategoryDatasetDemo();
    }

    protected abstract JFreeChart createChart(String var1, String var2, String var3, CategoryDataset var4);
}

