/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.g2dexport;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.report.output.OutputBorder;
import com.bokesoft.yes.report.output.OutputColor;
import com.bokesoft.yes.report.output.OutputDisplay;
import com.bokesoft.yes.report.output.OutputEmbedChart;
import com.bokesoft.yes.report.output.OutputEmbedImage;
import com.bokesoft.yes.report.output.OutputEmbedObject;
import com.bokesoft.yes.report.output.OutputEmbedText;
import com.bokesoft.yes.report.output.OutputFont;
import com.bokesoft.yes.report.print.IUnitTrans;
import com.bokesoft.yes.report.print.g2dexport.G2dBorderUtil;
import com.bokesoft.yes.report.print.g2dexport.G2dTransContext;
import com.bokesoft.yes.report.print.transform.IEmbedExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import com.bokesoft.yes.report.print.transform.PrinterColor;
import com.bokesoft.yes.report.util.FontFactory;
import com.bokesoft.yes.report.util.ReportUtil;
import com.bokesoft.yigo.report.delegate.IResourceResolver;
import com.bokesoft.yigo.report.print.chart.ReportChartFactory;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class G2dEmbedExport
implements IEmbedExport<G2dTransContext> {
    private IUnitTrans unitTrans = null;

    public G2dEmbedExport(IUnitTrans iUnitTrans) {
        this.unitTrans = iUnitTrans;
    }

    @Override
    public void export(G2dTransContext g2dTransContext, OutputEmbedObject outputEmbedObject, int n, int n2, int n3, int n4) {
        switch (outputEmbedObject.getType()) {
            case 0: {
                this.exportText(g2dTransContext, (OutputEmbedText)outputEmbedObject, n, n2, n3, n4);
                return;
            }
            case 2: {
                this.exportChart(g2dTransContext, (OutputEmbedChart)outputEmbedObject, n, n2, n3, n4);
                return;
            }
            case 1: {
                this.exportImage(g2dTransContext, (OutputEmbedImage)outputEmbedObject, n, n2, n3, n4);
            }
        }
    }

    private void exportChart(G2dTransContext object, OutputEmbedChart outputEmbedChart, int n, int n2, int n3, int n4) {
        object = ((G2dTransContext)object).getG2d();
        ReportChartFactory.createChart(outputEmbedChart).draw((Graphics2D)object, (Rectangle2D)new Rectangle2D.Double(n, n2, n3, n4));
    }

    private void exportText(G2dTransContext object, OutputEmbedText outputEmbedText, int n, int n2, int n3, int n4) {
        if (!ReportUtil.isNeedOutput((ITransformContext)object, outputEmbedText)) {
            return;
        }
        Graphics2D graphics2D = ((G2dTransContext)object).getG2d();
        OutputDisplay outputDisplay = outputEmbedText.getDisplay();
        OutputBorder outputBorder = outputDisplay.getBorder();
        Object object2 = outputEmbedText.getBackColor();
        PrinterColor printerColor = null;
        if (object2 != null) {
            printerColor = new PrinterColor((OutputColor)object2);
        }
        if (printerColor != null) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(printerColor);
            graphics2D.fillRect(n + G2dBorderUtil.getStrokeWidth(outputBorder.getLeftStyle()), n2 + G2dBorderUtil.getStrokeWidth(outputBorder.getTopStyle()), n3 - G2dBorderUtil.getStrokeWidth(outputBorder.getLeftStyle()) - G2dBorderUtil.getStrokeWidth(outputBorder.getRightStyle()), n4 - G2dBorderUtil.getStrokeWidth(outputBorder.getTopStyle()) - G2dBorderUtil.getStrokeWidth(outputBorder.getBottomStyle()));
            graphics2D.setPaint((Paint)object2);
        }
        G2dBorderUtil.drawRectLines((G2dTransContext)object, n, n2, n3, n4, outputBorder);
        object2 = outputEmbedText.getText();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object = outputDisplay.getFont();
        int n5 = this.unitTrans.transFontSize(((OutputFont)object).getSize());
        object = FontFactory.getFont((OutputFont)object, n5);
        graphics2D.setFont((Font)object);
        object = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = ((FontMetrics)object).getStringBounds((String)object2, graphics2D);
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        if (1 == outputDisplay.getHorizontalAlignment()) {
            n = (int)((double)n + ((double)n3 - d2) / 2.0);
            n3 = ((FontMetrics)object).getAscent();
            int n6 = ((FontMetrics)object).getDescent();
            n2 += (n4 - (n3 + n6)) / 2 + n3;
        } else if (0 == outputDisplay.getHorizontalAlignment()) {
            n2 = (int)((double)n2 + ((double)n4 + d) / 2.0);
        }
        OutputColor outputColor = outputEmbedText.getForeColor();
        PrinterColor printerColor2 = new PrinterColor(outputColor);
        graphics2D.setColor(printerColor2);
        graphics2D.drawString((String)object2, (float)n, (float)n2);
    }

    private void exportImage(G2dTransContext object, OutputEmbedImage outputEmbedImage, int n, int n2, int n3, int n4) {
        Object object2 = ((G2dTransContext)object).getResourceResolver();
        if ((object2 = this.loadImage((IResourceResolver)object2, outputEmbedImage.getPath())) != null) {
            boolean bl;
            object = ((G2dTransContext)object).getG2d();
            int n5 = outputEmbedImage.getImageScaleType();
            int n6 = ((Image)object2).getWidth(null);
            int n7 = ((Image)object2).getHeight(null);
            boolean bl2 = n6 > n3;
            boolean bl3 = bl = n7 > n4;
            if (n5 == 0) {
                n5 = n + (n3 - n6) / 2;
                int n8 = n2 + (n4 - n7) / 2;
                int n9 = n + (n3 + n6) / 2;
                int n10 = n2 + (n4 + n7) / 2;
                int n11 = bl2 ? n : n5;
                int n12 = bl ? n2 : n8;
                n9 = bl2 ? n + n3 : n9;
                n10 = bl ? n2 + n4 : n10;
                n5 = bl2 ? n - n5 : 0;
                n = bl ? n2 - n8 : 0;
                n2 = bl2 ? n5 + n3 : n6;
                n3 = bl ? n + n4 : n7;
                ((Graphics)object).drawImage((Image)object2, n11, n12, n9, n10, n5, n, n2, n3, null);
                return;
            }
            if (n5 == 6) {
                n5 = bl2 ? n + n3 : n + n6;
                int n13 = bl ? n2 + n4 : n2 + n7;
                int n14 = bl2 ? n3 : n6;
                int n15 = bl ? n4 : n7;
                ((Graphics)object).drawImage((Image)object2, n, n2, n5, n13, 0, 0, n14, n15, null);
                return;
            }
            ((Graphics)object).drawImage((Image)object2, n, n2, n3, n4, null);
        }
    }

    private Image loadImage(IResourceResolver object, String object2) {
        if (StringUtil.isBlankOrNull((String)object2)) {
            return null;
        }
        if ((object = object.loadResource((String)object2)) == null) {
            return null;
        }
        object2 = null;
        try {
            object2 = ImageIO.read((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object2;
    }
}

