/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.paper;

import com.bokesoft.yes.report.output.OutputPage;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.print.paper.IPaperAction;
import com.bokesoft.yes.report.print.paper.IPrintPaper;
import com.bokesoft.yes.report.print.paper.PrintPaper;
import com.bokesoft.yes.report.print.paper.group.AbstractPrintOrderGroup;
import com.bokesoft.yes.report.print.paper.group.NormalPrintOrderGroup;
import com.bokesoft.yes.report.print.paper.group.PrimaryFirstPrintOrderGroup;
import java.util.ArrayList;
import java.util.List;

public class PrintPaperWorker {
    private OutputPageSet pageSet = null;
    private List<IPrintPaper> papers = new ArrayList<IPrintPaper>();

    public PrintPaperWorker() {
    }

    public PrintPaperWorker(OutputPageSet outputPageSet) {
        this();
        this.preparePapers(outputPageSet);
    }

    public void preparePapers(OutputPageSet outputPageSet) {
        this.preparePapers(outputPageSet, 0, outputPageSet.size() - 1);
    }

    public void preparePapers(OutputPageSet object, int n, int n2) {
        this.pageSet = object;
        this.papers.clear();
        PrintPaper printPaper = null;
        object = this.createPrintOrderGroup(((OutputPageSet)object).getPrintOrderType()).build((OutputPageSet)object, n, n2).values().iterator();
        while (object.hasNext()) {
            for (OutputPage outputPage : ((OutputPageSet)object.next()).getPageArray()) {
                if (printPaper == null || !outputPage.isVirtualPage() || !printPaper.isEmpty() && !printPaper.hasEnoughSpace4LayoutPage(outputPage)) {
                    printPaper = new PrintPaper();
                    this.papers.add(printPaper);
                }
                printPaper.add(outputPage);
            }
        }
    }

    public IPrintPaper getPaper(int n) {
        return this.papers.get(n);
    }

    public int getPaperCount() {
        return this.papers.size();
    }

    public void clearPapers() {
        this.papers.clear();
    }

    public void doPaperAction(IPaperAction iPaperAction) {
        if (iPaperAction == null) {
            return;
        }
        for (IPrintPaper iPrintPaper : this.papers) {
            iPaperAction.doAction(iPrintPaper);
        }
    }

    public String getTitle() {
        if (this.pageSet == null) {
            return "";
        }
        return this.pageSet.getTitle();
    }

    public int getPaperWidth() {
        if (this.papers.size() == 0) {
            return 0;
        }
        return this.getPaper(0).getWidth();
    }

    public int getPaperHeight() {
        if (this.papers.size() == 0) {
            return 0;
        }
        return this.getPaper(0).getHeight();
    }

    public int getPaperOrientation() {
        if (this.papers.size() == 0) {
            return 0;
        }
        return this.getPaper(0).getOrientation();
    }

    private AbstractPrintOrderGroup createPrintOrderGroup(int n) {
        switch (n) {
            case 0: {
                return new NormalPrintOrderGroup();
            }
            case 1: {
                return new PrimaryFirstPrintOrderGroup();
            }
        }
        return new NormalPrintOrderGroup();
    }
}

