/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.parser;

import com.bokesoft.yes.parser.IAsyncListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BlockingAsyncListener
implements IAsyncListener {
    final IAsyncListener listener;
    final CountDownLatch latch;

    BlockingAsyncListener(IAsyncListener iAsyncListener) {
        this(iAsyncListener, new CountDownLatch(1));
    }

    BlockingAsyncListener(IAsyncListener iAsyncListener, CountDownLatch countDownLatch) {
        this.listener = iAsyncListener;
        this.latch = countDownLatch;
    }

    @Override
    public void successed(Object object) throws Throwable {
        if (this.listener != null) {
            this.listener.successed(object);
        }
        this.latch.countDown();
    }

    @Override
    public void failed(Object object, Throwable throwable) {
        if (this.listener != null) {
            this.listener.failed(object, throwable);
        }
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.latch.await(l2, timeUnit);
    }

    public long getCount() {
        return this.latch.getCount();
    }
}

