/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.datatable;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.dbcache.datatable.ValueDiff;
import com.bokesoft.yes.mid.dbcache.datatable.ValueNotLoad;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.struct.datatable.filter.FilterEval;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.datatable.ICacheProvider;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class CacheDataTable
extends DataTable {
    private DataTableMetaData metaData;
    private int[] columnIndexes;
    private final DataTable readOnly;
    private Row[] readOnlyRows;
    private int readOnlyPos = -1;
    private HashMap<Integer, Integer> bookmarkMap;
    private DataTable writable;

    public static CacheDataTable newInstance(DataTable dataTable, DataTableMetaData object, int[] nArray, int[] nArray2, boolean n2) {
        object = new CacheDataTable(dataTable, (DataTableMetaData)object, nArray, nArray2);
        if (n2) {
            for (int n3 : nArray2) {
                Row row = dataTable.getRowByIndex(n3);
                Object[] objectArray = row.getDataList();
                for (int n4 : nArray) {
                    Object object2 = objectArray[n4];
                    if (object2 != ValueNotLoad.instance && !(object2 instanceof ValueDiff) || row.getState() == 1) continue;
                    return null;
                }
            }
        }
        return object;
    }

    public static CacheDataTable newInstance(DataTable dataTable, int[] nArray) {
        DataTable dataTable2 = dataTable;
        CacheDataTable cacheDataTable = new CacheDataTable(dataTable2, dataTable2.getMetaData(), null, nArray);
        for (int n2 : nArray) {
            Row row = dataTable.getRowByIndex(n2);
            for (Object object : row.getDataList()) {
                if (object != ValueNotLoad.instance && !(object instanceof ValueDiff) || row.getState() == 1) continue;
                return null;
            }
        }
        return cacheDataTable;
    }

    public static CacheDataTable newInstance(DataTable dataTable) {
        DataTable dataTable2 = dataTable;
        return new CacheDataTable(dataTable2, dataTable2.getMetaData(), null, null);
    }

    public CacheDataTable(DataTable object, DataTableMetaData dataTableMetaData, int[] object2, int[] nArray) {
        this.readOnly = object;
        super.setKey(object.getKey());
        this.metaData = dataTableMetaData;
        this.columnIndexes = object2;
        try {
            if (nArray != null) {
                this.bookmarkMap = DataTableExUtil.getBookmarkMap(this);
                int n2 = nArray.length;
                this.readOnlyRows = new Row[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = nArray[i2];
                    Row row = this.readOnly.getRowByIndex(n3);
                    object2 = row;
                    int n4 = row.getBookmark();
                    Row row2 = new Row(this.readOnly, false);
                    row2.putAttr("row_bookmark", String.valueOf(n4));
                    Object[] objectArray = object2.getDataList();
                    object2 = objectArray;
                    System.arraycopy(objectArray, 0, row2.getDataList(), 0, ((int[])object2).length);
                    row2.setState(0);
                    this.readOnlyRows[i2] = row2;
                    this.bookmarkMap.put(n4, i2);
                }
                return;
            }
            this.bookmarkMap = DataTableExUtil.getBookmarkMap(object);
            this.readOnlyRows = null;
            CacheDataTable cacheDataTable = this;
            DataTableExUtil.getFieldBookmarkMap().set((Object)cacheDataTable, cacheDataTable.bookmarkMap);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
            throw new RuntimeException((Throwable)object);
        }
    }

    public void setMetaData(DataTableMetaData dataTableMetaData, MetaTable metaTable) {
        if (this.writable != null) {
            throw new RuntimeException("\u9519\u8bef\u7684\u7a0b\u5e8f\u8c03\u7528\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        this.metaData = dataTableMetaData;
        if (this.columnIndexes == null) {
            int n2 = dataTableMetaData.getColumnCount();
            DataTableMetaData dataTableMetaData2 = this.readOnly.getMetaData();
            this.columnIndexes = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = dataTableMetaData.getColumnInfo(i2).getColumnKey();
                string = ((MetaColumn)metaTable.get(string)).getBindingDBColumnName();
                this.columnIndexes[i2] = dataTableMetaData2.findColumnIndexByKey(string);
            }
        }
    }

    private DataTableMetaData getNewMetaData() {
        return this.metaData;
    }

    private DataTable getReadOnly() {
        return this.readOnly;
    }

    private DataTable getWritable() {
        return this.writable;
    }

    private DataTable getWritableNotNull() {
        if (this.writable == null) {
            try {
                Object[] objectArray;
                Object[] objectArray2;
                Row row;
                int n2;
                int n3;
                int n4 = this.isValid() ? this.getBookmark() : -1;
                DataTable dataTable = new DataTable(this.metaData);
                dataTable.setKey(super.getKey());
                int n5 = -1;
                if (this.readOnlyRows == null) {
                    n3 = this.readOnly.size();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        n2 = dataTable.append();
                        row = DataTableExUtil.getRowByIndex(dataTable, n2);
                        Row row2 = DataTableExUtil.getRowByIndex(this.readOnly, i2);
                        objectArray2 = row.getDataList();
                        objectArray = row2.getDataList();
                        if (this.columnIndexes == null) {
                            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        } else {
                            for (int n6 : this.columnIndexes) {
                                if (n6 == -1) continue;
                                objectArray2[n7] = objectArray[n6];
                            }
                        }
                        int n7 = row2.getBookmark();
                        n5 = n7 > n5 ? n7 : n5;
                        row.putAttr("row_bookmark", String.valueOf(n7));
                        row.setParentBookmark(row2.getParentBookmark());
                        row.stateUpdate();
                    }
                } else {
                    Row[] rowArray = this.readOnlyRows;
                    n3 = this.readOnlyRows.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        row = rowArray[n2];
                        int n82 = dataTable.append();
                        objectArray2 = DataTableExUtil.getRowByIndex(dataTable, n82);
                        objectArray = objectArray2.getDataList();
                        Object[] objectArray3 = row.getDataList();
                        if (this.columnIndexes == null) {
                            System.arraycopy(objectArray3, 0, objectArray, 0, objectArray3.length);
                        } else {
                            for (int n82 : this.columnIndexes) {
                                if (n82 == -1) continue;
                                objectArray[n9] = objectArray3[n82];
                            }
                        }
                        int n9 = row.getBookmark();
                        n5 = n9 > n5 ? n9 : n5;
                        objectArray2.putAttr("row_bookmark", String.valueOf(n9));
                        objectArray2.setParentBookmark(row.getParentBookmark());
                        objectArray2.stateUpdate();
                    }
                }
                HashMap<Integer, Integer> hashMap = DataTableExUtil.getBookmarkMap(dataTable);
                hashMap.clear();
                n2 = dataTable.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    hashMap.put(dataTable.getBookmark(n3), n3);
                }
                if (n4 >= 0) {
                    dataTable.setBookmark(n4);
                }
                dataTable.putAttr("bookmark_seed", String.valueOf(n5 + 1));
                this.bookmarkMap = hashMap;
                DataTableExUtil.getFieldBookmarkMap().set((Object)this, hashMap);
                this.writable = dataTable;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                throw new RuntimeException(throwable2);
            }
        }
        return this.writable;
    }

    private Row getRow(int n2) {
        Row row = this.writable == null ? (this.readOnlyRows == null ? this.readOnly.getRowByIndex(n2) : this.readOnlyRows[n2]) : this.writable.getRowByIndex(n2);
        return row;
    }

    public int addColumn(ColumnInfo columnInfo) throws StructException {
        return this.getWritableNotNull().addColumn(columnInfo);
    }

    public int addColumn(int n2, ColumnInfo columnInfo) throws StructException {
        return this.getWritableNotNull().addColumn(n2, columnInfo);
    }

    public void removeColumn(String string) throws StructException {
        this.getWritableNotNull().removeColumn(string);
    }

    private final void doColumnDataChange(int n2, boolean bl) {
    }

    public DataTableMetaData getMetaData() {
        DataTable dataTable = this.getWritable();
        if (dataTable != null) {
            return dataTable.getMetaData();
        }
        return this.getNewMetaData();
    }

    public void setFilter(String string) throws Throwable {
        this.getWritableNotNull().setFilter(string);
    }

    public void setFilterEval(FilterEval filterEval) {
        this.getWritableNotNull().setFilterEval(filterEval);
    }

    public String getFilter() {
        return this.getWritableNotNull().getFilter();
    }

    public void filter() throws Throwable {
        this.getWritableNotNull().filter();
    }

    public ArrayList<Integer> filter(String string) throws Throwable {
        return this.getWritableNotNull().filter(string);
    }

    public ArrayList<Integer> filter(FilterEval filterEval) throws Throwable {
        return this.getWritableNotNull().filter(filterEval);
    }

    public void setSort(String string, boolean bl) throws StructException {
        this.getWritableNotNull().setSort(string, bl);
    }

    public void setSort(SortCriteria[] sortCriteriaArray) throws StructException {
        this.getWritableNotNull().setSort(sortCriteriaArray);
    }

    public SortCriteria[] getSortCriteria() {
        return this.getWritableNotNull().getSortCriteria();
    }

    public void clearCriteria() {
        this.getWritableNotNull().clearCriteria();
    }

    public void sort() throws Throwable {
        this.getWritableNotNull().sort();
    }

    public void setShowDeleted(boolean bl) throws Throwable {
        if (this.writable != null) {
            this.writable.setShowDeleted(bl);
            return;
        }
        super.setShowDeletedFlag(bl);
    }

    public void setShowDeletedFlag(boolean bl) {
        if (this.writable != null) {
            this.writable.setShowDeletedFlag(bl);
            return;
        }
        super.setShowDeletedFlag(bl);
    }

    public void clearFilter() throws Throwable {
        this.getWritableNotNull().clearFilter();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.getWritableNotNull().writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.getWritableNotNull().readExternal(objectInput);
    }

    public DataTable deepClone() {
        return this.getWritableNotNull().deepClone();
    }

    public void setPos(int n2) throws StructException {
        if (this.writable == null) {
            this.readOnlyPos = n2;
            return;
        }
        this.writable.setPos(n2);
    }

    public int getPos() {
        if (this.writable == null) {
            return this.readOnlyPos;
        }
        return this.writable.getPos();
    }

    public void beforeFirst() {
        this.setPos(-1);
    }

    public void afterLast() {
        if (this.writable == null) {
            int n2;
            this.readOnlyPos = n2 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return;
        }
        this.writable.afterLast();
    }

    public boolean next() {
        if (this.writable == null) {
            if (this.isAfterLast()) {
                return false;
            }
            ++this.readOnlyPos;
            return !this.isAfterLast();
        }
        return this.writable.next();
    }

    public boolean next(boolean bl) {
        return this.getWritableNotNull().next(bl);
    }

    public boolean previous() {
        if (this.writable == null) {
            if (this.isBeforeFirst()) {
                return false;
            }
            --this.readOnlyPos;
            return !this.isBeforeFirst();
        }
        return this.writable.previous();
    }

    public boolean first() {
        if (this.writable == null) {
            if ((this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length) == 0) {
                return false;
            }
            this.readOnlyPos = 0;
            return true;
        }
        return this.writable.first();
    }

    public boolean last() {
        if (this.writable == null) {
            int n2 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            if (n2 == 0) {
                return false;
            }
            this.readOnlyPos = n2 - 1;
            return true;
        }
        return this.writable.last();
    }

    public int size() {
        if (this.writable == null) {
            if (this.readOnlyRows == null) {
                return this.readOnly.size();
            }
            return this.readOnlyRows.length;
        }
        return this.writable.size();
    }

    public boolean isEmpty() {
        if (this.writable == null) {
            return (this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length) == 0;
        }
        return this.writable.isEmpty();
    }

    public boolean isBeforeFirst() {
        if (this.writable == null) {
            return this.readOnlyPos == -1;
        }
        return this.writable.isBeforeFirst();
    }

    public boolean isAfterLast() {
        if (this.writable == null) {
            int n2;
            int n3 = n2 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return this.readOnlyPos == n2;
        }
        return this.writable.isAfterLast();
    }

    public boolean isFirst() {
        if (this.writable == null) {
            return (this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length) != 0 && this.readOnlyPos == 0;
        }
        return this.writable.isFirst();
    }

    public boolean isLast() {
        if (this.writable == null) {
            int n2 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return n2 != 0 && this.readOnlyPos == n2 - 1;
        }
        return this.writable.isLast();
    }

    public boolean isValid() {
        if (this.writable == null) {
            int n2 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return n2 != 0 && this.readOnlyPos >= 0 && this.readOnlyPos < n2;
        }
        return this.writable.isValid();
    }

    public Object getOriginalObject(int n2, int n3) {
        return this.getWritableNotNull().getObject(n2, n3);
    }

    public Object getOriginalObject(int n2, String string) throws StructException {
        return this.getWritableNotNull().getOriginalObject(n2, string);
    }

    public Object getOriginalObject(int n2) {
        return this.getWritableNotNull().getOriginalObject(n2);
    }

    public Object getOriginalObject(String string) throws StructException {
        return this.getWritableNotNull().getOriginalObject(string);
    }

    public Object getObject(int n2, int n3) {
        if (this.writable == null) {
            if (this.columnIndexes != null) {
                if (n3 >= this.columnIndexes.length) {
                    return null;
                }
                if ((n3 = this.columnIndexes[n3]) == -1) {
                    return null;
                }
            }
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(n2) : this.readOnlyRows[n2]).getObject(n3);
        }
        return this.writable.getObject(n2, n3);
    }

    public void setObject(int n2, int n3, Object object) {
        this.getWritableNotNull().setObject(n2, n3, object);
    }

    public void setObject(int n2, int n3, Object object, boolean bl) {
        this.getWritableNotNull().setObject(n2, n3, object, bl);
    }

    public Object getObject(int n2, String string) throws StructException {
        int n3 = this.metaData.findColumnIndexByKey(string, true);
        return this.getObject(n2, n3);
    }

    public Object impl_getObject(int n2, String string) throws StructException {
        int n3 = this.metaData.impl_findColumnIndexByKey(string, true);
        return this.getObject(n2, n3);
    }

    public void setObject(int n2, String string, Object object) throws StructException {
        this.getWritableNotNull().setObject(n2, string, object);
    }

    public Object getObject(int n2) {
        if (this.writable == null) {
            if (this.columnIndexes != null) {
                if (n2 >= this.columnIndexes.length) {
                    return null;
                }
                if ((n2 = this.columnIndexes[n2]) == -1) {
                    return null;
                }
            }
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).getObject(n2);
        }
        return this.writable.getObject(n2);
    }

    public void setObject(int n2, Object object) {
        this.getWritableNotNull().setObject(n2, object);
    }

    public Object getObject(String string) throws StructException {
        if (this.writable == null) {
            int n2 = this.metaData.findColumnIndexByKey(string);
            if (this.columnIndexes != null) {
                if (n2 >= this.columnIndexes.length) {
                    return null;
                }
                if ((n2 = this.columnIndexes[n2]) == -1) {
                    return null;
                }
            }
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).getObject(n2);
        }
        return this.writable.getObject(string);
    }

    public Object impl_getObject(String string) throws StructException {
        if (this.writable == null) {
            int n2 = this.metaData.impl_findColumnIndexByKey(string);
            if (this.columnIndexes != null) {
                if (n2 >= this.columnIndexes.length) {
                    return null;
                }
                if ((n2 = this.columnIndexes[n2]) == -1) {
                    return null;
                }
            }
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).getObject(n2);
        }
        return this.writable.impl_getObject(string);
    }

    public void setObject(String string, Object object) throws StructException {
        this.getWritableNotNull().setObject(string, object);
    }

    public void setObject(String string, Object object, boolean bl) throws StructException {
        this.getWritableNotNull().setObject(string, object, bl);
    }

    public Integer getInt(int n2, int n3) {
        return TypeConvertor.toInteger((Object)this.getObject(n2, n3));
    }

    public void setInt(int n2, int n3, Integer n4) {
        this.setObject(n2, n3, (Object)n4);
    }

    public Integer getInt(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getInt(n2, n3);
    }

    public void setInt(int n2, String string, Integer n3) throws StructException {
        int n4 = this.getNewMetaData().findColumnIndexByKey(string, true);
        this.setInt(n2, n4, n3);
    }

    public Integer getInt(int n2) {
        return TypeConvertor.toInteger((Object)this.getObject(n2));
    }

    public void setInt(int n2, Integer n3) {
        this.getWritableNotNull().setInt(n2, n3);
    }

    public Integer getInt(String string) throws StructException {
        return TypeConvertor.toInteger((Object)this.getObject(string));
    }

    public void setInt(String string, Integer n2) throws StructException {
        this.getWritableNotNull().setInt(string, n2);
    }

    public String getString(int n2, int n3) {
        return (String)this.getObject(n2, n3);
    }

    public void setString(int n2, int n3, String string) {
        this.setObject(n2, n3, (Object)string);
    }

    public String getString(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getString(n2, n3);
    }

    public void setString(int n2, String string, String string2) throws StructException {
        this.getWritableNotNull().setString(n2, string, string2);
    }

    public String getString(int n2) {
        return (String)this.getObject(n2);
    }

    public void setString(int n2, String string) {
        this.getWritableNotNull().setString(n2, string);
    }

    public String getString(String string) throws StructException {
        return (String)this.getObject(string);
    }

    public void setString(String string, String string2) throws StructException {
        this.getWritableNotNull().setString(string, string2);
    }

    public Date getDateTime(int n2, int n3) {
        return (Date)this.getObject(n2, n3);
    }

    public void setDateTime(int n2, int n3, Date date) {
        this.getWritableNotNull().setDateTime(n2, n3, date);
    }

    public Date getDateTime(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getDateTime(n2, n3);
    }

    public void setDateTime(int n2, String string, Date date) throws StructException {
        this.getWritableNotNull().setDateTime(n2, string, date);
    }

    public Date getDateTime(int n2) {
        return (Date)this.getObject(n2);
    }

    public void setDateTime(int n2, Date date) {
        this.getWritableNotNull().setDateTime(n2, date);
    }

    public Date getDateTime(String string) throws StructException {
        return (Date)this.getObject(string);
    }

    public void setDateTime(String string, Date date) throws StructException {
        this.getWritableNotNull().setDateTime(string, date);
    }

    public BigDecimal getNumeric(int n2, int n3) {
        return (BigDecimal)this.getObject(n2, n3);
    }

    public void setNumeric(int n2, int n3, BigDecimal bigDecimal) {
        this.getWritableNotNull().setNumeric(n2, n3, bigDecimal);
    }

    public BigDecimal getNumeric(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getNumeric(n2, n3);
    }

    public void setNumeric(int n2, String string, BigDecimal bigDecimal) throws StructException {
        this.getWritableNotNull().setNumeric(n2, string, bigDecimal);
    }

    public BigDecimal getNumeric(int n2) {
        return (BigDecimal)this.getObject(n2);
    }

    public void setNumeric(int n2, BigDecimal bigDecimal) {
        this.getWritableNotNull().setNumeric(n2, bigDecimal);
    }

    public BigDecimal getNumeric(String string) throws StructException {
        return (BigDecimal)this.getObject(string);
    }

    public void setNumeric(String string, BigDecimal bigDecimal) throws StructException {
        this.getWritableNotNull().setNumeric(string, bigDecimal);
    }

    public byte[] getBinary(int n2, int n3) {
        return (byte[])this.getObject(n2, n3);
    }

    public void setBinary(int n2, int n3, byte[] byArray) {
        this.getWritableNotNull().setBinary(n2, n3, byArray);
    }

    public byte[] getBinary(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getBinary(n2, n3);
    }

    public void setBinary(int n2, String string, byte[] byArray) throws StructException {
        this.getWritableNotNull().setBinary(n2, string, byArray);
    }

    public byte[] getBinary(int n2) {
        return (byte[])this.getObject(n2);
    }

    public void setBinary(int n2, byte[] byArray) {
        this.getWritableNotNull().setBinary(n2, byArray);
    }

    public byte[] getBinary(String string) throws StructException {
        return (byte[])this.getObject(string);
    }

    public void setBinary(String string, byte[] byArray) throws StructException {
        this.getWritableNotNull().setBinary(string, byArray);
    }

    public Long getLong(int n2, int n3) {
        return TypeConvertor.toLong((Object)this.getObject(n2, n3));
    }

    public void setLong(int n2, int n3, Long l2) {
        this.getWritableNotNull().setLong(n2, n3, l2);
    }

    public Long getLong(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getLong(n2, n3);
    }

    public void setLong(int n2, String string, Long l2) throws StructException {
        this.getWritableNotNull().setLong(n2, string, l2);
    }

    public Long getLong(int n2) {
        return TypeConvertor.toLong((Object)this.getObject(n2));
    }

    public void setLong(int n2, Long l2) {
        this.getWritableNotNull().setLong(n2, l2);
    }

    public Long getLong(String string) throws StructException {
        return TypeConvertor.toLong((Object)this.getObject(string));
    }

    public void setLong(String string, Long l2) throws StructException {
        this.getWritableNotNull().setLong(string, l2);
    }

    public Boolean getBoolean(int n2, int n3) {
        return (Boolean)this.getObject(n2, n3);
    }

    public void setBoolean(int n2, int n3, Boolean bl) {
        this.setObject(n2, n3, (Object)bl);
    }

    public Boolean getBoolean(int n2, String string) throws StructException {
        int n3 = this.getNewMetaData().findColumnIndexByKey(string, true);
        return this.getBoolean(n2, n3);
    }

    public void setBoolean(int n2, String string, Boolean bl) throws StructException {
        this.getWritableNotNull().setBoolean(n2, string, bl);
    }

    public Boolean getBoolean(int n2) {
        return (Boolean)this.getObject(n2);
    }

    public void setBoolean(int n2, Boolean bl) {
        this.getWritableNotNull().setBoolean(n2, bl);
    }

    public Boolean getBoolean(String string) throws StructException {
        return (Boolean)this.getObject(string);
    }

    public void setBoolean(String string, Boolean bl) throws StructException {
        this.getWritableNotNull().setBoolean(string, bl);
    }

    public int insert(int n2) {
        return this.getWritableNotNull().insert(n2);
    }

    public int insert() {
        return this.getWritableNotNull().insert();
    }

    public int append() {
        return this.getWritableNotNull().append();
    }

    public void delete(int n2) {
        this.getWritableNotNull().delete(n2);
    }

    public void deleteAll() {
        this.getWritableNotNull().deleteAll();
    }

    public void batchUpdate() {
        if (this.writable != null) {
            this.writable.batchUpdate();
        }
    }

    public void clearOriginalData() {
        if (this.writable != null) {
            this.writable.clearOriginalData();
        }
    }

    public void batchUpdate(boolean bl) {
        if (this.writable != null) {
            this.writable.batchUpdate(bl);
        }
    }

    public void delete() {
        this.getWritableNotNull().delete();
    }

    public int getState() {
        if (this.writable == null) {
            CacheDataTable cacheDataTable = this;
            return cacheDataTable.getState(cacheDataTable.readOnlyPos);
        }
        return this.writable.getState();
    }

    public void setState(int n2) {
        this.getWritableNotNull().setState(n2);
    }

    public int getState(int n2) {
        return this.getRow(n2).getState();
    }

    public int compare(Row row, Row row2) {
        return this.getWritableNotNull().compare(row, row2);
    }

    public int applyNewBookMark() {
        return this.getWritableNotNull().applyNewBookMark();
    }

    public int getBookmark() {
        if (this.writable == null) {
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).getBookmark();
        }
        return this.writable.getBookmark();
    }

    public int getParentBookmark() {
        if (this.writable == null) {
            return (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).getParentBookmark();
        }
        return this.writable.getParentBookmark();
    }

    public void setParentBookmark(int n2) {
        if (this.writable == null) {
            int n3 = this.getParentBookmark();
            if (n3 != n2) {
                if (n3 == -1) {
                    (this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos]).setParentBookmark(n2);
                    return;
                }
                this.getWritableNotNull().setParentBookmark(n2);
            }
            return;
        }
        this.writable.setParentBookmark(n2);
    }

    public int getParentBookmark(int n2) {
        return this.getRow(n2).getParentBookmark();
    }

    public void setParentBookmark(int n2, int n3) {
        if (this.writable == null) {
            int n4 = this.getParentBookmark(n2);
            if (n4 != n3) {
                if (n4 == -1) {
                    (this.readOnlyRows == null ? this.readOnly.getRowByIndex(n2) : this.readOnlyRows[n2]).setParentBookmark(n3);
                    return;
                }
                this.getWritableNotNull().setParentBookmark(n3);
            }
            return;
        }
        this.writable.setParentBookmark(n3);
    }

    public int getBookmark(int n2) {
        return this.getRow(n2).getBookmark();
    }

    public void setBookmark(int n2) throws StructException {
        if (this.writable == null) {
            Integer n3 = this.bookmarkMap.get(n2);
            if (n3 != null) {
                this.readOnlyPos = n3;
                return;
            }
            int n4 = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            throw new StructException(1, "bookmark: " + n2 + ", Size: " + n4);
        }
        this.writable.setBookmark(n2);
    }

    public boolean isBookmarkExist(int n2) {
        if (this.writable == null) {
            return this.bookmarkMap.containsKey(n2);
        }
        return this.writable.isBookmarkExist(n2);
    }

    public String getKey() {
        DataTable dataTable = this.getWritable();
        if (dataTable != null) {
            return dataTable.getKey();
        }
        return super.getKey();
    }

    public void setKey(String string) {
        String string2 = this.getKey();
        if ("".equals(string2)) {
            super.setKey(string);
            return;
        }
        if (!string.equals(string2)) {
            this.getWritableNotNull().setKey(string);
        }
    }

    public JSONObject toJSONWithNoData() throws SerializationException, JSONException {
        return this.getWritableNotNull().toJSONWithNoData();
    }

    public JSONObject toJSON() throws Throwable {
        return this.getWritableNotNull().toJSON();
    }

    public void fromJSON(JSONObject jSONObject) throws SerializationException, JSONException {
        this.getWritableNotNull().fromJSON(jSONObject);
    }

    public boolean isShowDeleted() {
        if (this.writable != null) {
            return this.writable.isShowDeleted();
        }
        return super.isShowDeleted();
    }

    public int findRow(String string, Object object) {
        return this.getWritableNotNull().findRow(string, object);
    }

    public int findRow(int n2, Object object) {
        return this.getWritableNotNull().findRow(n2, object);
    }

    public void clear() {
        super.clear();
        if (this.writable != null) {
            this.writable.clear();
        }
    }

    public Row getRowByIndex(int n2) {
        return this.getWritableNotNull().getRowByIndex(n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, false);
        return stringBuilder.toString();
    }

    public void appendString(StringBuilder stringBuilder, boolean bl) {
        if (this.writable == null) {
            if (bl) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("<Table key=\"");
            stringBuilder.append(this.readOnly.getKey());
            stringBuilder.append("\" curRowIndex=\"");
            stringBuilder.append(this.readOnlyPos);
            stringBuilder.append("\">\n");
            if (this.readOnlyRows != null) {
                Row[] rowArray = this.readOnlyRows;
                int n2 = this.readOnlyRows.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Row row = rowArray[i2];
                    stringBuilder.append(bl ? "\t\t" : "\t");
                    row.appendString(stringBuilder);
                }
            } else {
                int n3 = this.readOnly.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Row row = this.readOnly.getRowByIndex(i3);
                    stringBuilder.append(bl ? "\t\t" : "\t");
                    row.appendString(stringBuilder);
                }
            }
            if (bl) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("</Table>\n");
            return;
        }
        this.getWritableNotNull().appendString(stringBuilder, bl);
    }

    public DataTable cloneEmpty() throws StructException {
        return this.getWritableNotNull().cloneEmpty();
    }

    public void setNew() {
        this.getWritableNotNull().setNew();
    }

    public Object[] impl_getRow() {
        return this.getWritableNotNull().impl_getRow();
    }

    public IJSONHandler newHandler(String string) {
        return this.getWritable().newHandler(string);
    }

    public void putAttr(String string, String string2) {
        this.getWritable().putAttr(string, string2);
    }

    public void endHandler() {
    }

    public void endChildHandler(IJSONHandler iJSONHandler) {
    }

    public void setCache(ICacheProvider iCacheProvider) {
        this.getWritableNotNull().setCache(iCacheProvider);
    }

    public ICacheProvider getCache() {
        return this.getWritableNotNull().getCache();
    }

    public void close() {
        DataTable dataTable = this.getWritable();
        if (dataTable != null) {
            dataTable.close();
        }
    }

    public CacheDataTable copyReadOnly() throws Throwable {
        CacheDataTable cacheDataTable = new CacheDataTable(this.readOnly, this.metaData, this.columnIndexes, null);
        if (this.readOnlyRows != null) {
            int n2 = this.readOnlyRows.length;
            Row[] rowArray = new Row[n2];
            System.arraycopy(this.readOnlyRows, 0, rowArray, 0, n2);
            cacheDataTable.readOnlyRows = rowArray;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Row row = rowArray[i2];
                hashMap.put(row.getBookmark(), i2);
            }
            cacheDataTable.bookmarkMap = hashMap;
            DataTableExUtil.getFieldBookmarkMap().set((Object)cacheDataTable, hashMap);
            cacheDataTable.readOnlyPos = 0;
        }
        return cacheDataTable;
    }

    public CacheDataTable copyReadOnlyByMaxRows(int n2) throws Throwable {
        int n3;
        CacheDataTable cacheDataTable = new CacheDataTable(this.readOnly, this.metaData, this.columnIndexes, null);
        n2 = this.size() < n2 ? this.size() : n2;
        Row[] rowArray = new Row[n2];
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (this.readOnlyRows != null) {
            System.arraycopy(this.readOnlyRows, 0, rowArray, 0, n2);
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                Row row;
                rowArray[n3] = row = this.readOnly.getRowByIndex(n3);
            }
        }
        n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = rowArray[i2].getBookmark();
            n3 = Integer.max(n3, n4);
            hashMap.put(n4, i2);
        }
        cacheDataTable.readOnlyRows = rowArray;
        cacheDataTable.bookmarkMap = hashMap;
        DataTableExUtil.getFieldBookmarkMap().set((Object)cacheDataTable, hashMap);
        cacheDataTable.readOnlyPos = 0;
        return cacheDataTable;
    }

    public int fastFindFirst(String[] stringArray, Object[] objectArray) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFindFirst(stringArray, objectArray);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastFindFirst(stringArray, objectArray);
        }
        return this.getWritableNotNull().fastFindFirst(stringArray, objectArray);
    }

    public int[] fastFilter(String[] stringArray, Object[] objectArray) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFilter(stringArray, objectArray);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastFilter(stringArray, objectArray);
        }
        return this.getWritableNotNull().fastFilter(stringArray, objectArray);
    }

    public int[] fastFilter(String string, Object object) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFilter(string, object);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastFilter(string, object);
        }
        return this.getWritableNotNull().fastFilter(string, object);
    }

    public int[] fastSort(int[] nArray, SortCriteria[] sortCriteriaArray) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastSort(nArray, sortCriteriaArray);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastSort(nArray, sortCriteriaArray);
        }
        return this.getWritableNotNull().fastSort(nArray, sortCriteriaArray);
    }
}

