/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.datamigration.calculate.MetaMigrationParas;
import com.bokesoft.yes.mid.util.MigrationI18NUtil;
import com.bokesoft.yes.struct.datatable.DataTableParser;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckScript;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationValueCompare;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.migration.IMigrationDataCheck;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.ve.VE;
import java.math.BigDecimal;
import java.util.ArrayList;

public class MigrationDataCheckerImpl {
    private MetaDataMigration metaMigration;
    private MetaMigrationParas migrationParas;
    private boolean needLoadData = false;

    public MigrationDataCheckerImpl(DefaultContext defaultContext, MetaDataMigration metaDataMigration) throws Throwable {
        this.metaMigration = metaDataMigration;
        this.migrationParas = metaDataMigration.getMigrationParas(defaultContext.getVE().getMetaFactory());
        defaultContext = this.migrationParas.getTgtDataObject().getMigrationCheckRuleCollection();
        this.needLoadData = defaultContext != null && defaultContext.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void checkData(DefaultContext defaultContext, DataTable dataTable) throws Throwable {
        Object object;
        if (!this.needLoadData) {
            return;
        }
        if (this.migrationParas.getTgtDataObject().getMigrationUpdateStrategy() == 4 || this.migrationParas.getTgtDataObject().getMigrationUpdateStrategy() == 5) {
            throw new MidCoreException(39, MidCoreException.formatMessage((ILocale)defaultContext.getEnv(), (int)39, (Object[])new Object[0]));
        }
        Object object2 = this.migrationParas.getTgtDataObject().getMigrationCheckRuleCollection();
        ArrayList<MetaMigrationValueCompare> arrayList = new ArrayList<MetaMigrationValueCompare>();
        ArrayList<MetaMigrationCheckScript> arrayList2 = new ArrayList<MetaMigrationCheckScript>();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (MetaMigrationCheckRule)object2.next();
            if (object instanceof MetaMigrationValueCompare) {
                arrayList.add((MetaMigrationValueCompare)object);
                continue;
            }
            if (!(object instanceof MetaMigrationCheckScript)) continue;
            arrayList2.add((MetaMigrationCheckScript)object);
        }
        object2 = null;
        if (arrayList2.size() > 0) {
            object2 = new DataTableParser(dataTable);
        }
        object = this.migrationParas.getTgtDataObject().getKey() + "(" + this.migrationParas.getTgtDataObject().getCaption() + ")";
        dataTable.beforeFirst();
        while (dataTable.next()) {
            Object object3;
            for (MetaMigrationValueCompare metaMigrationValueCompare : arrayList) {
                void var8_12;
                BigDecimal bigDecimal;
                object3 = TypeConvertor.toBigDecimal((Object)dataTable.getObject(metaMigrationValueCompare.getColumnKey()));
                if (((BigDecimal)object3).compareTo(bigDecimal = new BigDecimal(metaMigrationValueCompare.getValue())) != -1) continue;
                object3 = metaMigrationValueCompare.getErrorInfo();
                if (object3 != null && ((String)object3).length() > 0) {
                    Object object4 = object3;
                } else {
                    String string = MigrationI18NUtil.getStringWithArgs((MetaDataMigration)this.metaMigration, (VE)defaultContext.getVE(), (String)this.metaMigration.getKey(), (String)"MigrationRuleCheckConflict", (Object[])new Object[]{object, metaMigrationValueCompare.getDescription()});
                }
                throw new MidCoreException(16, (String)var8_12);
            }
            for (MetaMigrationCheckScript metaMigrationCheckScript : arrayList2) {
                switch (metaMigrationCheckScript.getType()) {
                    case 0: {
                        void var8_16;
                        if (TypeConvertor.toBoolean((Object)object2.eval(metaMigrationCheckScript.getType(), metaMigrationCheckScript.getContent())).booleanValue()) break;
                        object3 = metaMigrationCheckScript.getErrorInfo();
                        if (object3 != null && ((String)object3).length() > 0) {
                            Object object5 = object3;
                        } else {
                            String string = MigrationI18NUtil.getStringWithArgs((MetaDataMigration)this.metaMigration, (VE)defaultContext.getVE(), (String)this.metaMigration.getKey(), (String)"MigrationRuleCheckConflict", (Object[])new Object[]{object, metaMigrationCheckScript.getDescription()});
                        }
                        throw new MidCoreException(16, (String)var8_16);
                    }
                    case 2: {
                        String string = metaMigrationCheckScript.getContent();
                        if (StringUtil.isBlankOrNull((String)string)) break;
                        ((IMigrationDataCheck)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string)).check(defaultContext, dataTable);
                    }
                }
            }
        }
    }
}

