/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.utils;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportBillHandler {
    private IMetaFactory metaFactory = null;
    private String dataObjectKey = null;
    private HashMap<String, List<String>> importFields = null;
    private Workbook workbook = null;
    private Sheet mainSheet = null;
    private MetaDataObject metaDataObject = null;
    private DefaultContext context = null;
    public static String SEPARATOR = ";";

    public ImportBillHandler(DefaultContext defaultContext, Workbook workbook) throws Throwable {
        this.metaFactory = defaultContext.getVE().getMetaFactory();
        this.workbook = workbook;
        this.context = defaultContext;
        this.init(defaultContext);
    }

    private void init(DefaultContext defaultContext) throws Throwable {
        this.mainSheet = this.workbook.getSheetAt(0);
        this.dataObjectKey = ExcelUtil.getCellValue((Sheet)this.mainSheet, (int)0, (int)0).toString();
        this.metaDataObject = defaultContext.getVE().getMetaFactory().getDataObject(this.dataObjectKey);
        this.importFields = new HashMap();
        int n = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            String string;
            defaultContext = this.workbook.getSheetAt(i);
            String string2 = defaultContext.getSheetName();
            ArrayList<String> arrayList = new ArrayList<String>();
            this.importFields.put(string2, arrayList);
            int n2 = 1;
            while (!(string = ExcelUtil.getCellValue((Sheet)defaultContext, (int)0, (int)n2).toString()).isEmpty()) {
                arrayList.add(string);
                ++n2;
            }
        }
    }

    public String getDataObjectKey() {
        return this.dataObjectKey;
    }

    public MetaDataObject getDataObject() {
        return this.metaDataObject;
    }

    public HashMap<String, List<String>> getImportFields() {
        return this.importFields;
    }

    public List<String> getFieldsByTable(String string) {
        return this.importFields.get(string);
    }

    public Sheet getMainSheet() throws Throwable {
        return this.mainSheet;
    }

    public void fillImportField(MetaTable metaTable, DataTable dataTable, Sheet sheet, int n) throws Throwable {
        List<String> list = this.getFieldsByTable(metaTable.getKey());
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            String[] stringArray = ((String)object).split(ImportDictionaryHander.SEPARATOR);
            object = this.getValue(metaTable, sheet, n, i + 1, (String)object);
            dataTable.setObject(stringArray[0], object);
        }
    }

    private Object getValue(MetaTable metaTable, Sheet object, int n, int n2, String string) throws Throwable {
        Object object2;
        String string2;
        object = ExcelUtil.getCellValue((Sheet)object, (int)n, (int)n2);
        if (string.equals("Code")) {
            object = object.toString().toUpperCase();
        }
        if ((metaTable = (MetaColumn)metaTable.get(string2 = (object2 = string.split(ImportDictionaryHander.SEPARATOR))[0])) == null) {
            throw new MidCoreException(38, MidCoreException.formatMessage(null, (int)38, (Object[])new Object[]{string2}));
        }
        if (object != null && !object.toString().isEmpty()) {
            string2 = TypeConvertor.toString((Object)object);
            if (((String[])object2).length > 1) {
                object = 0;
                object2 = object2[1];
                string = this.context.getVE().getDictCache();
                MetaDataObject metaDataObject = this.metaFactory.getDataObject((String)object2);
                if (metaDataObject == null) {
                    throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[]{object2}));
                }
                for (MetaColumn metaColumn : metaDataObject.getDisplayColumns()) {
                    Object object3;
                    if (string2.contains(",") && metaTable.getDataType() == 1002) {
                        object3 = string.getAllItems((String)object2, null, 0, 0);
                        String[] stringArray = string2.split(",");
                        if (object3.size() == stringArray.length) {
                            object = 0;
                        } else {
                            object3 = "";
                            for (int i = 0; i < stringArray.length; ++i) {
                                object = string.locate((String)object2, metaColumn.getKey(), (Object)stringArray[i], null, null, 7, 0);
                                if (object == null) continue;
                                if (i != 0) {
                                    object = object.getID();
                                    object3 = (String)object3 + "," + object.toString();
                                    continue;
                                }
                                object3 = ((Object)object.getID()).toString();
                            }
                            object = object3;
                        }
                    } else {
                        object3 = string.locate((String)object2, metaColumn.getKey(), (Object)string2, null, null, 7, 0);
                        if (object3 != null) {
                            object = object3.getID();
                            break;
                        }
                    }
                    if (StringUtil.isBlankOrNull((Object)object)) continue;
                }
            }
        }
        return TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)metaTable.getDataType()), (Object)object);
    }

    public String getPrimayKey(Sheet sheet, int n, boolean bl) {
        return ExcelUtil.getCellValue((Sheet)sheet, (int)n, (int)0).toString();
    }
}

