/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.reader;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.IPictureDataItem;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureCell;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetReader
implements IInputReader {
    private Sheet sheet = null;
    private ExcelTemplateSheet templateSheet;
    private PictureSheet pictureSheet = null;

    public SheetReader(Sheet sheet, ExcelTemplateSheet excelTemplateSheet) {
        this.sheet = sheet;
        this.templateSheet = excelTemplateSheet;
    }

    @Override
    public Object getValue(int n, int n2, ExcelProcessContext excelProcessContext) {
        Object object = ExcelUtil.getCellValue((Sheet)this.sheet, (int)n, (int)n2);
        if (excelProcessContext == null) {
            return object;
        }
        ExcelTemplateField excelTemplateField = excelProcessContext.getCurTemplateField();
        if (excelTemplateField == null) {
            return object;
        }
        if (excelTemplateField.getDataType() == 7 || excelTemplateField.getDataType() == 8) {
            try {
                String string = this.getPictureValue(n, n2, excelTemplateField.getStorageService(), excelProcessContext);
                if (!StringUtil.isBlankOrNull((String)string)) {
                    object = string;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return object;
    }

    private String getPictureValue(int n, int n2, String string, ExcelProcessContext excelProcessContext) throws Throwable {
        if (this.pictureSheet == null) {
            this.pictureSheet = excelProcessContext.getPictureSheetBuilder().build(this.sheet);
        }
        if (this.pictureSheet.existPicture(n, n2)) {
            string = excelProcessContext.getStorage(string);
            PictureCell pictureCell = this.pictureSheet.getPictureCell(n, n2);
            ArrayList<IPictureDataItem> arrayList = pictureCell.getPictureItems();
            if (arrayList != null) {
                for (IPictureDataItem iPictureDataItem : arrayList) {
                    String string2 = string.save(iPictureDataItem.getData(), iPictureDataItem.getSuggestFileExtension(), (Object)excelProcessContext);
                    iPictureDataItem.setPath(string2);
                }
            }
            return pictureCell.getPaths();
        }
        return "";
    }

    @Override
    public boolean isEmptyTableRow(String string2, int n) {
        for (String string2 : this.templateSheet.getTemplateTable(string2).getFields()) {
            if (StringUtil.isBlankOrNull((Object)ExcelUtil.getCellValue((Sheet)this.sheet, (int)n, (int)string2.getColIndex()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmptySheetRow(int n) {
        Row row = this.sheet.getRow(n);
        if (row == null) {
            return true;
        }
        int n2 = row.getLastCellNum();
        for (int i = 0; i <= n2; ++i) {
            if (StringUtil.isBlankOrNull((Object)ExcelUtil.getCellValue((Sheet)this.sheet, (int)n, (int)i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    @Override
    public int getLastCellNum(int n) {
        Row row = this.sheet.getRow(n);
        if (row == null) {
            return 0;
        }
        return row.getLastCellNum();
    }
}

