/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp;

import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.process.InputDocumentProcess;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.InputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.InputRowCheckAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.WorkbookReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.PictureSheetBuilderFactory;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.InputStrategyFactory;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.builder.SheetTemplateBuilder;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportExcelWithStamp
implements IImport {
    private Workbook workbook = null;
    private DefaultContext context = null;
    private String postServiceName = null;
    private Document curDocument = null;

    public ImportExcelWithStamp(DefaultContext defaultContext, Workbook workbook, Document document, String string) throws Throwable {
        this.context = defaultContext;
        this.workbook = workbook;
        this.curDocument = document;
        this.postServiceName = string;
    }

    @Override
    public Object importData() throws Throwable {
        IInDocument<IInTable> iInDocument;
        IMetaFactory iMetaFactory = this.context.getVE().getMetaFactory();
        ExcelTemplate excelTemplate = new SheetTemplateBuilder("", this.workbook, iMetaFactory).create();
        Object object = iMetaFactory.getMetaForm(excelTemplate.getFormKey());
        iMetaFactory = MetaUtil.getDataObject((IMetaFactory)iMetaFactory, (MetaForm)object);
        object = new ExcelProcessContext(excelTemplate.getFormKey(), (MetaDataObject)iMetaFactory, this.context);
        ((ExcelProcessContext)object).setPictureSheetBuilder(PictureSheetBuilderFactory.createPictureSheetBuilder(this.workbook));
        Object object2 = new WorkbookReader(this.workbook, excelTemplate);
        InputDocumentProcess inputDocumentProcess = new InputDocumentProcess(excelTemplate);
        InputRowCheckAction inputRowCheckAction = new InputRowCheckAction();
        object2 = InputStrategyFactory.create(excelTemplate, (IInputReaderBag)object2, (ExcelProcessContext)object);
        Iterator<IInDocument<IInTable>> iterator = object2.iterator();
        while (iterator.hasNext()) {
            iInDocument = iterator.next();
            inputDocumentProcess.doProcess(iInDocument, null, inputRowCheckAction, (ExcelProcessContext)object);
        }
        if (((ExcelProcessContext)object).hasError()) {
            inputRowCheckAction = new JSONObject();
            inputRowCheckAction.put("CheckError", ((ExcelProcessContext)object).getError());
            return inputRowCheckAction;
        }
        inputRowCheckAction = new JSONArray();
        JSONArray jSONArray = new JSONArray();
        InputRowAction inputRowAction = new InputRowAction();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            iInDocument = iterator.next();
            try {
                if (this.isImportCurDocument(excelTemplate)) {
                    object2 = this.curDocument;
                } else {
                    object2 = DocumentUtil.newDocument((MetaDataObject)iMetaFactory);
                    object2.setNew();
                    object2.setOID(this.context.applyNewOID().longValue());
                }
                ((ExcelProcessContext)object).setCurDocument((Document)object2);
                OutDocument outDocument = new OutDocument((Document)object2);
                inputDocumentProcess.doProcess(iInDocument, outDocument, inputRowAction, (ExcelProcessContext)object);
                ExcelUtils.calcDefaultFormula((Document)object2, excelTemplate, this.context);
                outDocument = new DefaultContext(this.context);
                outDocument.setFormKey(this.context.getFormKey());
                ImportExcelWithStamp importExcelWithStamp = this;
                importExcelWithStamp.doPostProcessService(importExcelWithStamp.postServiceName, (Document)object2, (MetaDataObject)iMetaFactory, (DefaultContext)outDocument);
                if (!this.isImportCurDocument(excelTemplate)) {
                    new SaveData((MetaDataObject)iMetaFactory, null, (Document)object2).save((DefaultContext)outDocument);
                }
                jSONArray.put((Object)(iInDocument.getPrimaryValue() + "->" + object2.getOID()));
            }
            catch (Throwable throwable) {
                inputRowCheckAction.put(iInDocument.getPrimaryValue() + "->" + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        object2 = new JSONObject();
        object2.put("Fail", (Object)inputRowCheckAction);
        object2.put("Success", (Object)jSONArray);
        return object2;
    }

    private boolean isImportCurDocument(ExcelTemplate excelTemplate) {
        return this.curDocument != null && excelTemplate.getType() == EExcelTemplateType.Single;
    }

    private void doPostProcessService(String string, Document document, MetaDataObject metaDataObject, DefaultContext defaultContext) throws Throwable {
        if (string != null && !string.isEmpty() && (string = (IServiceProcess)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string)) != null) {
            defaultContext.setDocument(document);
            defaultContext.setDataObject(metaDataObject);
            string.process((IServiceContext)defaultContext);
        }
    }

    public static void main(String[] object) {
        object = "zzz+ddd";
        Lexer lexer = new Lexer();
        lexer.setContent((String)object);
        int n = lexer.next();
        while (n != -1) {
            if (n == 15 || n == 16) {
                String string = lexer.getLexValue();
                System.out.println(string);
            }
            n = lexer.next();
        }
    }
}

