/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportExcelWithFormula
implements IImport {
    private String formKey = null;
    private DefaultContext context;
    private MetaDataObject metaDataObject;
    private Workbook workbook;
    private String postImportServiceName;
    private Document document = null;
    private HashMap<String, List<String>> importFields = null;
    private String firstTableKey = null;

    public ImportExcelWithFormula(String string, DefaultContext defaultContext, MetaDataObject metaDataObject, Workbook workbook, Document document, boolean bl, String string2) {
        this.formKey = string;
        this.context = defaultContext;
        this.workbook = workbook;
        this.metaDataObject = metaDataObject;
        this.postImportServiceName = string2;
        this.document = document;
        this._init();
    }

    private void _init() {
        this.importFields = new HashMap();
        boolean bl = true;
        int n = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            String string;
            Sheet sheet = this.workbook.getSheetAt(i);
            String string2 = sheet.getSheetName();
            if (this.metaDataObject.getTable(string2) == null) continue;
            int n2 = 0;
            if (bl) {
                this.firstTableKey = string2;
                n2 = 1;
                bl = false;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!(string = ExcelUtil.getCellValue((Sheet)sheet, (int)0, (int)n2).toString()).isEmpty()) {
                arrayList.add(string);
                ++n2;
            }
            this.importFields.put(string2, arrayList);
        }
    }

    @Override
    public Object importData() throws Throwable {
        Sheet sheet;
        Object object;
        String string2;
        for (String string2 : this.importFields.keySet()) {
            object = this.metaDataObject.getTable(string2);
            sheet = ExcelUtil.getSheet((Workbook)this.workbook, (String)string2);
            switch (object.getTableMode()) {
                case 0: {
                    this.fillHeadData(sheet, this.document, string2);
                    break;
                }
                case 1: {
                    this.fillDetailData(sheet, this.document, string2);
                }
            }
        }
        if (this.postImportServiceName != null && !this.postImportServiceName.isEmpty() && (string2 = (IServiceProcess)ReflectHelper.newInstance((VE)this.context.getVE(), (String)this.postImportServiceName)) != null) {
            sheet = new DefaultContext(this.context);
            sheet.setDocument(this.document);
            sheet.setDataObject(this.metaDataObject);
            string2.process((IServiceContext)sheet);
        }
        ExcelUtils.calcDefaultFormula(this.document, this.importFields, this.context);
        string2 = this.document.toJSON();
        sheet = new JSONObject();
        for (String string3 : this.importFields.keySet()) {
            JSONArray jSONArray = new JSONArray();
            sheet.put(string3, (Object)jSONArray);
            for (String string4 : this.importFields.get(string3)) {
                jSONArray.put((Object)string4);
            }
        }
        object = this.context.getVE().getMetaFactory().getMetaForm(this.formKey);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("document", (Object)string2);
        jSONObject.put("IgnoreKeys", (Collection)MetaUtil.getIgnoreKeys((MetaForm)object, this.importFields));
        return jSONObject;
    }

    private void fillHeadData(Sheet sheet, Document document, String string) throws Throwable {
        MetaTable metaTable = this.metaDataObject.getMetaTable(string);
        document = document.get(string);
        document.first();
        this.fillImportField(metaTable, (DataTable)document, sheet, 2, this.importFields.get(string));
    }

    private void fillDetailData(Sheet sheet, Document document, String string) throws Throwable {
        MetaTable metaTable = this.metaDataObject.getMetaTable(string);
        document = document.get(string);
        int n = 2;
        while (true) {
            DocumentUtil.newRow((MetaTable)metaTable, (DataTable)document);
            if (this.fillImportField(metaTable, (DataTable)document, sheet, n, this.importFields.get(string))) {
                document.delete();
                return;
            }
            ++n;
        }
    }

    private boolean fillImportField(MetaTable metaTable, DataTable dataTable, Sheet sheet, int n, List<String> list) throws Throwable {
        boolean bl = true;
        boolean bl2 = this.firstTableKey.equals(metaTable.getKey());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            String[] stringArray = string.split(ImportDictionaryHander.SEPARATOR);
            Object object = ExcelUtil.getCellValue((Sheet)sheet, (int)n, (int)(bl2 ? i + 1 : i));
            if (TypeConvertor.toString((Object)object).isEmpty()) continue;
            bl = false;
            object = this.transformValue(metaTable, string, object);
            dataTable.setObject(stringArray[0], object);
        }
        return bl;
    }

    private Object transformValue(MetaTable metaTable, String object, Object object2) throws Throwable {
        object = object.split(ImportDictionaryHander.SEPARATOR);
        String string = object[0];
        if (((String[])object).length > 1) {
            object = object[1];
            IDictCacheProxy iDictCacheProxy = this.context.getVE().getDictCache();
            for (MetaColumn metaColumn : this.context.getVE().getMetaFactory().getDataObject((String)object).getDisplayColumns()) {
                if ((metaColumn = iDictCacheProxy.locate((String)object, metaColumn.getKey(), (Object)object2.toString(), null, null, 7, 0)) == null) continue;
                object2 = metaColumn.getID();
                break;
            }
        }
        return TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)((MetaColumn)metaTable.get(string)).getDataType()), (Object)object2);
    }
}

