/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.cmd.normal.DictChecker;
import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportBillHandler;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportDictionaryWithDoc
implements DictChecker,
IImport {
    private Workbook workbook = null;
    private ImportBillHandler handler = null;
    private DefaultContext context = null;
    private String postServiceName = null;
    private boolean isRepeatCode = false;
    private boolean clearOriginalData = false;

    public ImportDictionaryWithDoc(DefaultContext defaultContext, Workbook workbook, String string, boolean bl) throws Throwable {
        this.context = defaultContext;
        this.workbook = workbook;
        this.postServiceName = string;
        this.clearOriginalData = bl;
        this.handler = new ImportBillHandler(defaultContext, workbook);
    }

    @Override
    public Object importData() throws Throwable {
        String string;
        MetaDataObject metaDataObject = this.handler.getDataObject();
        Sheet sheet = this.handler.getMainSheet();
        int n = this.workbook.getNumberOfSheets();
        int n2 = 2;
        String string2 = sheet.getSheetName();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        MetaTable metaTable = metaDataObject.getTable(string2);
        if (metaTable == null) {
            LogSvr.getInstance().info("\u5bfc\u5165excel\u672a\u914d\u7f6e\u4e3b\u8868: ".concat(String.valueOf(string2)));
            return Boolean.TRUE;
        }
        while (!(string = ExcelUtil.getCellValue((Sheet)sheet, (int)n2, (int)1).toString()).isEmpty()) {
            Long l;
            Document document = DocumentUtil.newDocument((MetaDataObject)metaDataObject);
            document.setNew();
            DataTable dataTable = document.get(string2);
            String string3 = "select * from " + metaDataObject.getMainTable().getBindingDBTableName() + " where Code =?";
            string3 = this.context.getDBManager().execPrepareQuery(string3, new Object[]{string});
            boolean bl = this.isRepeatCode = string3 != null && string3.size() > 0;
            if (this.isRepeatCode()) {
                l = string3.getLong(0, "OID");
                document.setOID(l.longValue());
                document.put(string2, (DataTable)string3);
                dataTable = document.get(string2);
                if (this.clearOriginalData) {
                    this.clearOriginalData(n, l);
                }
            }
            if (metaTable.getTableMode() == 1) {
                DocumentUtil.newRow((MetaTable)metaTable, (DataTable)dataTable);
            } else {
                dataTable.first();
            }
            this.handler.fillImportField(metaTable, dataTable, sheet, n2);
            for (int i = 1; i < n; ++i) {
                ImportDictionaryWithDoc importDictionaryWithDoc = this;
                importDictionaryWithDoc.fillTableData(importDictionaryWithDoc.workbook.getSheetAt(i), metaDataObject, document, hashMap, string);
            }
            l = new DefaultContext(this.context);
            l.setFormKey(this.context.getFormKey());
            if (this.postServiceName != null && !this.postServiceName.isEmpty() && (string = (IServiceProcess)ReflectHelper.newInstance((VE)this.context.getVE(), (String)this.postServiceName)) != null) {
                l.setDocument(document);
                l.setDataObject(metaDataObject);
                string.process((IServiceContext)l);
            }
            if (this.isRepeatCode()) {
                ExcelUtils.calcDefaultFormula(document, this.handler.getImportFields(), this.context);
            }
            new SaveData(metaDataObject, null, document).save((DefaultContext)l);
            ++n2;
        }
        return Boolean.TRUE;
    }

    private void clearOriginalData(int n, Long l) throws Throwable {
        for (int i = 1; i < n; ++i) {
            String string = this.workbook.getSheetAt(i).getSheetName();
            IDBManager iDBManager = this.context.getDBManager();
            string = "DELETE FROM " + iDBManager.keyWordEscape(string) + " WHERE SOID=?";
            System.err.println(string);
            iDBManager.execPrepareUpdate(string, new Object[]{l});
        }
    }

    private void fillTableData(Sheet sheet, MetaDataObject metaDataObject, Document document, HashMap<String, Integer> hashMap, String string) throws Throwable {
        String string2 = sheet.getSheetName();
        if ((metaDataObject = metaDataObject.getTable(string2)) == null) {
            return;
        }
        int n = 2;
        if (hashMap.containsKey(string2)) {
            n = hashMap.get(string2);
        }
        document = document.get(string2);
        document.first();
        while (true) {
            if (!this.handler.getPrimayKey(sheet, n, false).equalsIgnoreCase(string)) {
                hashMap.put(string2, n);
                return;
            }
            if (metaDataObject.getTableMode() == 1) {
                DocumentUtil.newRow((MetaTable)metaDataObject, (DataTable)document);
            }
            this.handler.fillImportField((MetaTable)metaDataObject, (DataTable)document, sheet, n);
            ++n;
        }
    }

    @Override
    public boolean isRepeatCode() {
        return this.isRepeatCode;
    }
}

