/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.excel.cmd.normal.DictChecker;
import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yes.mid.cmd.dict.RebuildDictTreeCmd;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportDictionary
implements DictChecker,
IImport {
    private boolean clearOriginalData = false;
    private ImportDictionaryHander hander = null;
    private HashMap<String, Long> codes = new HashMap();
    private HashSet<String> existCodes = new HashSet();
    private DefaultContext context = null;
    private Workbook workbook = null;
    private String postServiceName = null;
    private boolean isRepeatCode = false;

    public ImportDictionary(DefaultContext defaultContext, Workbook workbook, boolean bl, String string) throws Throwable {
        this.context = defaultContext;
        this.workbook = workbook;
        this.postServiceName = string;
        this.hander = new ImportDictionaryHander(defaultContext, workbook);
        this.clearOriginalData = bl;
    }

    @Override
    public Object importData() throws Throwable {
        IServiceProcess iServiceProcess;
        Sheet sheet;
        String string = this.hander.getItemKey();
        MetaDataObject metaDataObject = this.context.getVE().getMetaFactory().getDataObject(string);
        if (metaDataObject == null) {
            return Boolean.TRUE;
        }
        boolean bl = true;
        int n = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            sheet = this.workbook.getSheetAt(i);
            this.processImportData(string, sheet, bl);
            bl = false;
        }
        if (this.postServiceName != null && !this.postServiceName.isEmpty() && (iServiceProcess = (IServiceProcess)ReflectHelper.newInstance((VE)this.context.getVE(), (String)this.postServiceName)) != null) {
            sheet = new DefaultContext(this.context);
            sheet.setDataObject(metaDataObject);
            iServiceProcess.process((IServiceContext)sheet);
        }
        this.context.commit();
        RebuildDictTreeCmd rebuildDictTreeCmd = new RebuildDictTreeCmd();
        rebuildDictTreeCmd.setItemKey(string);
        rebuildDictTreeCmd.doCmd(this.context);
        this.context.getVE().getDictCache().removeDictCache(string);
        return string;
    }

    private void processImportData(String string, Sheet sheet, boolean bl) throws Throwable {
        String string2 = sheet.getSheetName();
        if (bl) {
            this.dealFirstSheet(string, sheet);
            return;
        }
        switch (this.context.getVE().getMetaFactory().getDataObject(string).getTable(string2).getTableMode()) {
            case 0: {
                this.dealHeadSheet(string, sheet);
                return;
            }
            case 1: {
                this.dealDtlSheet(string, sheet);
            }
        }
    }

    private void dealHeadSheet(String string, Sheet sheet) throws Throwable {
        String string2;
        String string3 = sheet.getSheetName();
        string = this.context.getVE().getMetaFactory().getDataObject(string).getTable(string3);
        ArrayList<String> arrayList = this.hander.getFieldsByTable(string3);
        String string4 = this.hander.getInsertSQLByTable(string3);
        string4 = new BatchPsPara(string4);
        string3 = this.hander.getUpdateSQLByTable(string3);
        string3 = new BatchPsPara(string3);
        int n = 2;
        while (!(string2 = ExcelUtil.getCellValue((Sheet)sheet, (int)n, (int)0).toString().toUpperCase()).isEmpty()) {
            boolean bl = this.existCodes.contains(string2);
            this.setRepeatCode(bl);
            long l = this.codes.get(string2);
            string2 = new PSArgs();
            if (!this.isRepeatCode()) {
                long l2 = this.context.applyNewOID();
                string4.putArgs((PSArgs)string2);
                this.fillSystemField((MetaTable)string, (PSArgs)string2, l2, l);
            }
            this.fillImportField((MetaTable)string, (PSArgs)string2, sheet, n, arrayList);
            if (this.isRepeatCode()) {
                string2.addArg(string.getSOIDColumn().getDataType(), (Object)l);
                string3.putArgs((PSArgs)string2);
            }
            ++n;
        }
        string2 = this.context.getDBManager();
        string2.executeUpdate((BatchPsPara)string3);
        string2.executeUpdate((BatchPsPara)string4);
    }

    private void setRepeatCode(boolean bl) {
        this.isRepeatCode = bl;
    }

    private void dealDtlSheet(String string, Sheet sheet) throws Throwable {
        String string2;
        String string3 = sheet.getSheetName();
        string = this.context.getVE().getMetaFactory().getDataObject(string).getTable(string3);
        ArrayList<String> arrayList = this.hander.getFieldsByTable(string3);
        String string4 = this.hander.getInsertSQLByTable(string3);
        string4 = new BatchPsPara(string4);
        string3 = this.hander.getDeleteSQLByTable(string3);
        string3 = new BatchPsPara(string3);
        int n = 2;
        while (!(string2 = ExcelUtil.getCellValue((Sheet)sheet, (int)n, (int)0).toString().toUpperCase()).isEmpty()) {
            long l = this.codes.get(string2);
            if (this.clearOriginalData) {
                string2 = new PSArgs();
                string2.addArg(string.getSOIDColumn().getDataType(), (Object)l);
                string3.putArgs((PSArgs)string2);
            }
            long l2 = this.context.applyNewOID();
            string2 = new PSArgs();
            this.fillSystemField((MetaTable)string, (PSArgs)string2, l2, l);
            this.fillImportField((MetaTable)string, (PSArgs)string2, sheet, n, arrayList);
            string4.putArgs((PSArgs)string2);
            ++n;
        }
        string2 = this.context.getDBManager();
        string2.executeUpdate((BatchPsPara)string3);
        string2.executeUpdate((BatchPsPara)string4);
    }

    private void dealFirstSheet(String string, Sheet sheet) throws Throwable {
        PSArgs pSArgs;
        String string2 = sheet.getSheetName();
        MetaTable metaTable = this.context.getVE().getMetaFactory().getDataObject(string).getTable(string2);
        ArrayList<String> arrayList = this.hander.getFieldsByTable(string2);
        String string3 = this.hander.getInsertSQLByTable(string2);
        string3 = new BatchPsPara(string3);
        string2 = this.hander.getUpdateSQLByTable(string2);
        string2 = new BatchPsPara(string2);
        IDictCacheProxy iDictCacheProxy = this.context.getVE().getDictCache();
        int n = 2;
        while (true) {
            boolean bl;
            long l;
            pSArgs = new PSArgs();
            String string4 = ExcelUtil.getCellValue((Sheet)sheet, (int)n, (int)1).toString().toUpperCase();
            if (string4.isEmpty()) break;
            if (this.codes.containsKey(string4)) {
                throw new RuntimeException("\u5b57\u5178" + string + "\u5bfc\u5165\u6a21\u677f\u7684code=" + string4 + "\u53d1\u73b0\u91cd\u590d.");
            }
            Item item = iDictCacheProxy.locate(string, "Code", (Object)string4, null, null, 7, 0);
            if (item == null) {
                l = this.context.applyNewOID();
                bl = false;
            } else {
                l = item.getID();
                this.existCodes.add(string4);
                bl = true;
            }
            this.codes.put(string4, l);
            this.setRepeatCode(bl);
            if (!this.isRepeatCode()) {
                string3.putArgs(pSArgs);
                long l2 = l;
                this.fillSystemField(metaTable, pSArgs, l2, l2);
            }
            this.fillImportField(metaTable, pSArgs, sheet, n, arrayList);
            if (this.isRepeatCode()) {
                string2.putArgs(pSArgs);
                pSArgs.addArg(metaTable.getSOIDColumn().getDataType(), (Object)l);
            }
            ++n;
        }
        pSArgs = this.context.getDBManager();
        pSArgs.executeUpdate((BatchPsPara)string3);
        pSArgs.executeUpdate((BatchPsPara)string2);
    }

    private void fillSystemField(MetaTable metaTable, PSArgs pSArgs, long l, long l2) {
        pSArgs.addArg(metaTable.getOIDColumn().getDataType(), (Object)l);
        pSArgs.addArg(metaTable.getPOIDColumn().getDataType(), null);
        pSArgs.addArg(metaTable.getSOIDColumn().getDataType(), (Object)l2);
        pSArgs.addArg(metaTable.getVERIDColumn().getDataType(), (Object)0);
        pSArgs.addArg(metaTable.getDVERIDColumn().getDataType(), (Object)0);
    }

    private void fillImportField(MetaTable metaTable, PSArgs pSArgs, Sheet sheet, int n, ArrayList<String> arrayList) throws Throwable {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            Object object = this.getValue(metaTable, sheet, n, i + 1, string);
            pSArgs.addArg(((MetaColumn)metaTable.get(string.split(ImportDictionaryHander.SEPARATOR)[0])).getDataType(), object);
        }
    }

    private Object getValue(MetaTable metaTable, Sheet object, int n, int n2, String string) throws Throwable {
        object = ExcelUtil.getCellValue((Sheet)object, (int)n, (int)n2);
        if (string.equals("Code")) {
            object = object.toString().toUpperCase();
        }
        Object object2 = string.split(ImportDictionaryHander.SEPARATOR);
        String string2 = object2[0];
        if (object != null && !object.toString().isEmpty()) {
            string = TypeConvertor.toString((Object)object);
            if (((String[])object2).length > 1) {
                object = 0;
                if ((object2 = object2[1]).equals(this.hander.getItemKey()) && this.codes.containsKey(string.toUpperCase())) {
                    object = this.codes.get(string.toUpperCase());
                } else {
                    IDictCacheProxy iDictCacheProxy = this.context.getVE().getDictCache();
                    for (MetaColumn metaColumn : this.context.getVE().getMetaFactory().getDataObject((String)object2).getDisplayColumns()) {
                        if ((metaColumn = iDictCacheProxy.locate((String)object2, metaColumn.getKey(), (Object)string, null, null, 7, 0)) == null) continue;
                        object = metaColumn.getID();
                        break;
                    }
                }
            }
        }
        return TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)((MetaColumn)metaTable.get(string2)).getDataType()), (Object)object);
    }

    @Override
    public boolean isRepeatCode() {
        return this.isRepeatCode;
    }
}

