/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.normal.ExportComponentInfo;
import com.bokesoft.yes.excel.cmd.normal.ExportExcelParas;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.json.JSONObject;

public class ExportDictWithTemplate
implements IExport {
    private DefaultContext context = null;
    private String itemKey = null;
    private String postExportServiceName;
    private Workbook workBook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private String exportFileName = null;
    private boolean needDownload = false;
    private ExcelStyleFactory styleFactory = null;
    private ExportExcelParas paras = null;
    private MetaForm metaForm = null;
    private ArrayList<Map<String, ArrayList<Map<Object, Object>>>> datas = new ArrayList();

    public ExportDictWithTemplate(DefaultContext defaultContext, MetaExcelWorkbook metaExcelWorkbook, String string, String string2, String string3, boolean bl) throws Throwable {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.postExportServiceName = string2;
        this.exportFileName = string3;
        this.needDownload = bl;
        metaExcelWorkbook = defaultContext.getVE().getMetaFactory();
        this.metaForm = metaExcelWorkbook.getMetaForm(string);
        this.itemKey = this.metaForm.getDataSource().getDataObject().getKey();
        this.paras = new ExportExcelParas(defaultContext, this.metaForm);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileData exportData() throws Throwable {
        Object object;
        PsPara psPara;
        block10: {
            ResultSet resultSet = null;
            psPara = null;
            new FileData();
            try {
                Long l;
                object = this.metaWorkbook.getFormKey();
                MetaForm metaForm = this.context.getVE().getMetaFactory().getMetaForm((String)object);
                MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
                object = this.context.getDBManager();
                this.virtualWorkbook = new ExcelWorkbook(metaDataObject, this.metaWorkbook, this.context.getMidParser());
                this.workBook = new SXSSFWorkbook(500);
                ExportDictWithTemplate exportDictWithTemplate = this;
                Object object2 = exportDictWithTemplate.getDictSql(exportDictWithTemplate.context, this.itemKey);
                psPara = new PsPara(object.preparedQueryStatement(object2.getSQL()), object2.getSQL());
                resultSet = object.executeQuery(psPara, (QueryArguments)new NormalQueryArguments(object2.getPrepareValues().toArray()));
                while (resultSet.next()) {
                    l = TypeConvertor.toLong((Object)resultSet.getObject(1));
                    this.prepareSingleData(new DefaultContext(this.context), l, metaDataObject);
                }
                l = this.context.getVE().getMetaFactory();
                Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
                while (iterator.hasNext()) {
                    JSONObject jSONObject = new JSONObject();
                    object = iterator.next();
                    object2 = ExcelUtil.getSheet((Workbook)this.workBook, (String)((ExcelSheet)object).getName());
                    Iterator<ExcelRow> iterator2 = ((ExcelSheet)object).iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        int n = ((ExcelRow)object).getRowIndex() - 1;
                        ExcelUtil.getRow((Sheet)object2, (int)n);
                        Iterator<ExcelCell> iterator3 = ((ExcelRow)object).iterator();
                        while (iterator3.hasNext()) {
                            ExcelCell excelCell = iterator3.next();
                            String string = excelCell.getSourceType();
                            int n2 = excelCell.getCellIndex() - 1;
                            Cell cell = ExcelUtil.getCell((Row)ExcelUtil.getRow((Sheet)object2, (int)n), (int)n2);
                            this.fillData((Sheet)object2, cell, (ExcelRow)object, excelCell, string, jSONObject, metaDataObject.getMainTableKey());
                        }
                    }
                }
                String string = ExcelUtils.getExportFilePath((IMetaFactory)l, metaForm.getKey());
                object = !this.needDownload ? ExcelFileUtil.writeExcel(this.workBook, string) : ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), this.exportFileName, this.workBook);
                object2 = ExcelUtils.getPostExtProcess(this.context, this.postExportServiceName);
                if (object2 != null) {
                    object2.process(this.context, (FileData)object);
                }
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psPara != null) {
                    psPara.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        psPara.close();
        if (!this.needDownload) {
            return new FileData();
        }
        return object;
    }

    private void fillData(Sheet sheet, Cell object, ExcelRow object2, ExcelCell excelCell, String string, JSONObject jSONObject, String string2) {
        int n = object.getRowIndex();
        int n2 = object.getColumnIndex();
        ExcelDisplay excelDisplay = excelCell.getDisplay();
        boolean bl = false;
        int n3 = 0;
        if (excelDisplay != null && excelDisplay.getFormat() != null) {
            n3 = excelDisplay.getFormat().getDataType();
        }
        this.styleFactory = new ExcelStyleFactory(this.workBook);
        Object object3 = jSONObject.keys();
        while (object3.hasNext()) {
            String string3 = (String)object3.next();
            if (n2 != TypeConvertor.toInteger((Object)string3)) continue;
            n = jSONObject.getInt(string3);
        }
        object.setCellStyle(this.styleFactory.getCellStyle(excelCell));
        if (string.equalsIgnoreCase("const")) {
            ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)n2, (Object)excelCell.getDefinition());
            ++n;
        } else if (string.equalsIgnoreCase("field")) {
            int n4 = ((ExcelRow)object2).getType();
            object = ((ExcelRow)object2).getTableKey();
            object2 = excelCell.getTableKey();
            for (int i = 0; i < this.datas.size(); ++i) {
                object3 = this.datas.get(i);
                Object object4 = this.getTableKey(n4, (String)object, (String)object2);
                if ((object4 = (ArrayList)object3.get(object4)) == null) continue;
                for (int j = 0; j < ((ArrayList)object4).size(); ++j) {
                    Object object5 = n4 == 3 && ((String)object2).equals(string2) ? (Map)((ArrayList)object3.get(object2)).get(0) : (Map)((ArrayList)object4).get(j);
                    object5 = object5.get(excelCell.getDefinition());
                    if (n3 == 2) {
                        object5 = new BigDecimal(object5.toString());
                    }
                    ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)n2, object5);
                    ExcelUtil.getCell((Sheet)sheet, (int)(++n), (int)n2).setCellStyle(this.styleFactory.getCellStyle(excelCell));
                }
            }
        }
        if (excelDisplay != null) {
            bl = excelDisplay.isWrapText();
        }
        if (bl) {
            this.styleFactory.getCellStyle(excelCell).setWrapText(bl);
        }
        jSONObject.put(TypeConvertor.toString((Object)n2), (Object)TypeConvertor.toString((Object)n));
    }

    private String getTableKey(int n, String string, String string2) {
        if (n == 3) {
            return string;
        }
        if (string2 != null && !string2.isEmpty()) {
            return string2;
        }
        return string;
    }

    private Font createDefaultFont(Workbook workbook) {
        workbook = workbook.createFont();
        workbook.setBold(false);
        workbook.setItalic(false);
        workbook.setFontName("\u5b8b\u4f53");
        workbook.setFontHeightInPoints((short)12);
        return workbook;
    }

    private PrepareSQL getDictSql(DefaultContext object, String string) throws Throwable {
        MetaTable metaTable = object.getVE().getMetaFactory().getDataObject(string).getMainTable();
        String string2 = metaTable.getOIDColumn().getBindingDBColumnName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        stringBuffer.append(string2);
        stringBuffer.append(" from ");
        stringBuffer.append(metaTable.getBindingDBTableName());
        ArrayList arrayList = new ArrayList();
        object = AuthorityCheckUtil.dictAuthoritySql((DefaultContext)object, (String)string, (String)string2, (int)0);
        if (object != null && !StringUtil.isBlankOrNull((String)object.getSQL())) {
            stringBuffer.append(" where " + object.getSQL());
            arrayList.addAll(object.getPrepareValues());
        }
        object = this.getOrderBySQL(metaTable);
        stringBuffer.append(" order by ");
        stringBuffer.append((String)object);
        object = new PrepareSQL();
        object.setSQL(stringBuffer.toString());
        object.addAllValue(arrayList);
        return object;
    }

    private String getOrderBySQL(MetaTable metaTable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (MetaColumn metaColumn : metaTable) {
            switch (metaColumn.getSort()) {
                case 1: {
                    stringBuffer.append(",");
                    stringBuffer.append(metaColumn.getBindingDBColumnName());
                    break;
                }
                case 2: {
                    stringBuffer.append(",");
                    stringBuffer.append(metaColumn.getBindingDBColumnName());
                    stringBuffer.append(" Desc");
                }
            }
        }
        if (stringBuffer.length() == 0) {
            Iterator iterator = (MetaColumn)metaTable.get("TLeft");
            stringBuffer.append(",");
            stringBuffer.append(iterator.getBindingDBColumnName());
        }
        return stringBuffer.toString().substring(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareSingleData(DefaultContext defaultContext, long l, MetaDataObject metaDataObject2) throws Throwable {
        FilterMap filterMap = new FilterMap();
        filterMap.setOID(l);
        Document document = new LoadMultiPageDocument(defaultContext, filterMap, null).reloadDocument(this.metaForm);
        try {
            HashMap<String, ArrayList<Map<Object, Object>>> hashMap = new HashMap<String, ArrayList<Map<Object, Object>>>();
            for (MetaDataObject metaDataObject2 : metaDataObject2.getTableCollection()) {
                this.prepareData(defaultContext, (MetaTable)metaDataObject2, document, hashMap, metaDataObject2.getTableMode());
            }
            this.datas.add(hashMap);
            if (document == null) return;
        }
        catch (Throwable throwable) {
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private void prepareData(DefaultContext defaultContext, MetaTable object, Document object2, Map<String, ArrayList<Map<Object, Object>>> map, int n) throws Throwable {
        object = object.getKey();
        ArrayList<String> arrayList = this.paras.getColumnListByTableKey((String)object);
        HashMap<String, ExportComponentInfo> hashMap = this.paras.getComponentInfoByTableKey((String)object);
        Object object3 = null;
        ArrayList arrayList2 = new ArrayList();
        DataTable dataTable = object2.get((String)object);
        dataTable.beforeFirst();
        while (dataTable.next(true)) {
            Iterator<String> iterator = arrayList.iterator();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            while (iterator.hasNext()) {
                String string = iterator.next();
                object2 = hashMap.get(string);
                if (object2 != null) {
                    object3 = DataTransferUtil.convertFieldValue((VE)defaultContext.getVE(), this.metaForm, ((ExportComponentInfo)object2).getControlType(), ((ExportComponentInfo)object2).getProperties(), dataTable, string);
                }
                hashMap2.put(string, object3);
            }
            arrayList2.add(hashMap2);
        }
        if (arrayList2.size() <= 0) {
            return;
        }
        map.put((String)object, arrayList2);
    }
}

