/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.normal.ExportComponentInfo;
import com.bokesoft.yes.excel.cmd.normal.ExportExcelParas;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BatchExportTools {
    private Workbook workbook = null;
    private MetaForm exportMetaForm;
    private MetaDataObject exportMetaDataObject;
    private ExportExcelParas paras;
    private HashMap<String, Integer> sheetRowIndex = new HashMap();
    private ExcelStyleFactory styleFactory = null;

    public BatchExportTools(MetaForm metaForm, ExportExcelParas exportExcelParas) {
        this.paras = exportExcelParas;
        this.exportMetaForm = metaForm;
        this.exportMetaDataObject = metaForm.getDataSource().getDataObject();
        this.workbook = new SXSSFWorkbook(1000);
        this.styleFactory = new ExcelStyleFactory(this.workbook);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportSingleData(DefaultContext defaultContext, long l) throws Throwable {
        MetaTable metaTable = this.exportMetaDataObject.getMainTable();
        FilterMap filterMap = new FilterMap();
        filterMap.setOID(l);
        Document document = new LoadMultiPageDocument(defaultContext, filterMap, null).reloadDocument(this.exportMetaForm);
        try {
            String string = document.get(metaTable.getKey()).getObject(this.paras.getRelationalKey()).toString();
            for (MetaTable metaTable2 : this.exportMetaDataObject.getTableCollection()) {
                String string2 = metaTable2.getCaption();
                Sheet sheet = ExcelUtil.getSheet((Workbook)this.workbook, (String)string2);
                boolean bl = metaTable == metaTable2;
                this.fillData(defaultContext, sheet, metaTable2, bl, document, string);
            }
            if (document == null) return;
        }
        catch (Throwable throwable) {
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private void fillData(DefaultContext defaultContext, Sheet sheet, MetaTable object, boolean bl, Document object2, String string) throws Throwable {
        object = object.getKey();
        ArrayList<String> arrayList = this.paras.getColumnListByTableKey((String)object);
        HashMap<String, ExportComponentInfo> hashMap = this.paras.getComponentInfoByTableKey((String)object);
        int n = this.sheetRowIndex.get(sheet.getSheetName());
        DataTable dataTable = object2.get((String)object);
        dataTable.beforeFirst();
        while (dataTable.next(true)) {
            int n2 = 0;
            if (!bl) {
                ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)0, (Object)string);
                ++n2;
            }
            for (String string2 : arrayList) {
                MetaComponent metaComponent = this.exportMetaForm.componentByKey(string2);
                object2 = hashMap.get(string2);
                if (object2 == null) continue;
                object2 = DataTransferUtil.convertFieldValue((VE)defaultContext.getVE(), this.exportMetaForm, ((ExportComponentInfo)object2).getControlType(), ((ExportComponentInfo)object2).getProperties(), dataTable, string2);
                ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)n2, (Object)object2);
                if (metaComponent != null) {
                    ExcelUtil.getCell((Sheet)sheet, (int)n, (int)n2).setCellStyle(this.styleFactory.getCellStyle(metaComponent));
                }
                ++n2;
            }
            ++n;
        }
        this.sheetRowIndex.put(sheet.getSheetName(), n);
    }

    public void exportTitleData() {
        MetaTable metaTable = this.exportMetaDataObject.getMainTable();
        for (MetaTable metaTable2 : this.exportMetaDataObject.getTableCollection()) {
            String string = metaTable2.getCaption();
            string = ExcelUtil.getSheet((Workbook)this.workbook, (String)string);
            boolean bl = metaTable == metaTable2;
            this.fillTitleData((Sheet)string, metaTable2, bl);
        }
    }

    private void fillTitleData(Sheet sheet, MetaTable metaTable, boolean bl) {
        Object object = metaTable.getKey();
        Object object2 = this.paras.getColumnListByTableKey((String)object);
        object = this.paras.getComponentInfoByTableKey((String)object);
        int n = 0;
        if (object2 == null) {
            this.sheetRowIndex.put(sheet.getSheetName(), 0);
            return;
        }
        if (!bl) {
            ExcelUtil.setCellValue((Sheet)sheet, (int)0, (int)0, (Object)this.paras.getRelationalCaption());
            ++n;
        }
        object2 = ((ArrayList)object2).iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            MetaComponent metaComponent = null;
            Object object3 = this.exportMetaForm.componentByKey(string);
            if (object3 != null) {
                metaComponent = this.exportMetaForm.componentByKey(object3.getBuddyKey());
            }
            if ((object3 = (ExportComponentInfo)((HashMap)object).get(string)) == null) {
                object3 = (MetaColumn)metaTable.get(string);
                ExcelUtil.setCellValue((Sheet)sheet, (int)0, (int)n, (Object)object3.getCaption());
            } else {
                ExcelUtil.setCellValue((Sheet)sheet, (int)0, (int)n, (Object)((ExportComponentInfo)object3).getCaption());
            }
            if (metaComponent != null) {
                ExcelUtil.getCell((Sheet)sheet, (int)0, (int)n).setCellStyle(this.styleFactory.getCellStyle(metaComponent));
            }
            ++n;
        }
        this.sheetRowIndex.put(sheet.getSheetName(), 1);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }
}

