/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.cmd.stamp.ExportExcelWithStamp;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;

public class StampExcelUtil {
    public static FileData exportExcelWithStamp(DefaultContext defaultContext, String string, Document document, FilterMap filterMap, ConditionParas conditionParas, String string2, String string3, AbstractRuntimeUIConfig abstractRuntimeUIConfig, String string4, boolean bl, String string5, String string6) throws Throwable {
        string3 = EExcelTemplateType.valueOf((String)string3);
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        try {
            iMetaFactory = iMetaFactory.getMetaForm(string);
            filterMap.setType(1);
            if (DocumentUtil.isPaginationForm((String)string, (DefaultContext)defaultContext)) {
                document = new LoadMultiPageDocument(new DefaultContext(defaultContext), filterMap, conditionParas).reloadDocument((MetaForm)iMetaFactory);
            }
            string = new ExportExcelWithStamp(defaultContext, string2, (EExcelTemplateType)string3, iMetaFactory.getKey(), document, abstractRuntimeUIConfig, string5, string6, bl).exportData();
            if (bl) {
                StampExcelUtil.downLoadFileData((FileData)string, string4);
            }
            defaultContext.commit();
        }
        catch (Throwable throwable) {
            if (defaultContext != null) {
                defaultContext.rollback();
            }
            throw throwable;
        }
        finally {
            if (defaultContext != null) {
                defaultContext.close();
            }
        }
        return string;
    }

    public static byte[] exportExcelBytesWithStamp(DefaultContext defaultContext, String object, Document document, FilterMap filterMap, ConditionParas conditionParas, String string, String string2) throws Throwable {
        string2 = EExcelTemplateType.valueOf((String)string2);
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        try {
            iMetaFactory = iMetaFactory.getMetaForm((String)object);
            filterMap.setType(1);
            if (DocumentUtil.isPaginationForm((String)object, (DefaultContext)defaultContext)) {
                document = new LoadMultiPageDocument(new DefaultContext(defaultContext), filterMap, conditionParas).reloadDocument((MetaForm)iMetaFactory);
            }
            object = new ExportExcelWithStamp(defaultContext, string, (EExcelTemplateType)string2, iMetaFactory.getKey(), document, null, "", "", true).exportToBytes();
            defaultContext.commit();
        }
        catch (Throwable throwable) {
            if (defaultContext != null) {
                defaultContext.rollback();
            }
            throw throwable;
        }
        finally {
            if (defaultContext != null) {
                defaultContext.close();
            }
        }
        return object;
    }

    public static short getExcelDataFormatType(String string, Workbook workbook) {
        short s = -1;
        if (!StringUtil.isBlankOrNull((String)string)) {
            s = workbook.createDataFormat().getFormat(string);
        }
        return s;
    }

    public static boolean isNumericCell(int n) {
        return n == 5 || n == 2;
    }

    public static short getExcelCellStyle(ExcelCell excelCell, Workbook workbook) {
        if (excelCell.getDisplay() == null || excelCell.getDisplay().getFormat() == null) {
            return -1;
        }
        return StampExcelUtil.getExcelDataFormatType(excelCell.getDisplay().getFormat().getFormatString(), workbook);
    }

    public static boolean isNumericCell(ExcelCell excelCell) {
        if (excelCell.getDisplay() == null || excelCell.getDisplay().getFormat() == null) {
            return false;
        }
        return StampExcelUtil.isNumericCell(excelCell.getDisplay().getFormat().getDataType());
    }

    public static boolean downLoadFileData(FileData object, String object2) throws Exception {
        if (!((File)(object2 = new File((String)object2))).exists()) {
            ((File)object2).createNewFile();
        }
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            object = object.getData();
            object = new ByteArrayInputStream((byte[])object);
            bufferedInputStream = new BufferedInputStream((InputStream)object);
            fileOutputStream = new FileOutputStream((File)object2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            object = new byte[1024];
            int n = bufferedInputStream.read((byte[])object);
            while (n != -1) {
                ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                n = bufferedInputStream.read((byte[])object);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            throw throwable;
        }
        bufferedInputStream.close();
        fileOutputStream.close();
        filterOutputStream.close();
        return true;
    }
}

