/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.util;

import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.cmd.stamp.dependency.provider.IExpFieldItemProvider;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExportService;
import com.bokesoft.yigo.meta.enhance.MetaPostExportService;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class ExcelUtils {
    private static final boolean CALC_ON = false;

    public static IExportService getExpService(DefaultContext defaultContext, String string) throws Throwable {
        MetaEnhance metaEnhance;
        IExportService iExportService = null;
        MetaExportService metaExportService = null;
        if (string != null && !string.isEmpty() && (metaEnhance = defaultContext.getVE().getMetaFactory().getEnhance(null)) != null && (metaEnhance = metaEnhance.getExtExportService()) != null) {
            metaExportService = (MetaExportService)metaEnhance.get(string);
        }
        if (metaExportService != null) {
            iExportService = (IExportService)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)metaExportService.getImpl());
        }
        return iExportService;
    }

    public static IExportPostProcess getPostExtProcess(DefaultContext defaultContext, String string) throws Throwable {
        MetaEnhance metaEnhance;
        IExportPostProcess iExportPostProcess = null;
        MetaPostExportService metaPostExportService = null;
        if (string != null && !string.isEmpty() && (metaEnhance = defaultContext.getVE().getMetaFactory().getEnhance(null)) != null && (metaEnhance = metaEnhance.getPostExportService()) != null) {
            metaPostExportService = (MetaPostExportService)metaEnhance.get(string);
        }
        if (metaPostExportService != null) {
            iExportPostProcess = (IExportPostProcess)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)metaPostExportService.getImpl());
        }
        return iExportPostProcess;
    }

    public static String getExportFilePath(IMetaFactory object, String string) throws Throwable {
        if ((object = object.getSolution().getDataPath()) == null || ((String)object).isEmpty()) {
            object = SvrInfo.getWorkDir();
        }
        object = FileUtil.removeSlant((String)object);
        return (String)object + File.separator + "Excel" + File.separator + string + File.separator + string + System.currentTimeMillis() + ".xlsx";
    }

    public static String getExportFilePathByUUID(IMetaFactory object, String string) throws Throwable {
        if ((object = object.getSolution().getDataPath()) == null || ((String)object).isEmpty()) {
            object = SvrInfo.getWorkDir();
        }
        object = FileUtil.removeSlant((String)object);
        return (String)object + File.separator + "Excel" + File.separator + string + File.separator + string + UUID.randomUUID() + ".xlsx";
    }

    public static List<Long> getOIDsFromDocument(Document document) {
        String string = document.getMetaDataObject().getMainTableKey();
        MetaTable metaTable = document.getMetaDataObject().getMetaTable(string);
        return ExcelUtils.getOIDs(document.get(string), metaTable.getOIDColumn().getKey());
    }

    public static List<Long> getOIDs(DataTable dataTable, String string) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        dataTable.beforeFirst();
        while (dataTable.next(true)) {
            Long l = dataTable.getLong(string);
            arrayList.add(l);
        }
        return arrayList;
    }

    public static void calcDefaultFormula(Document document, ExcelTemplate excelTemplate, DefaultContext defaultContext) throws Throwable {
    }

    public static void calcDefaultFormula(Document document, HashMap<String, List<String>> hashMap, DefaultContext defaultContext) throws Throwable {
    }

    private static void calcDefaultFormula(IExpFieldItemProvider iExpFieldItemProvider, DefaultContext defaultContext) throws Throwable {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNeedLoadData(MetaForm metaForm, List<MetaTable> metaTable) {
        Iterator iterator = metaTable.iterator();
        block7: while (iterator.hasNext()) {
            metaTable = (MetaTable)iterator.next();
            switch (metaTable.getTableMode()) {
                case 1: {
                    metaTable = metaForm.findComponentByTable(metaTable.getKey());
                    if (metaTable == null) continue block7;
                    switch (metaTable.getControlType()) {
                        case 217: {
                            if (((MetaGrid)metaTable).getPageLoadType() != 2) break;
                            return true;
                        }
                        case 216: {
                            if (((MetaListView)metaTable).getPageLoadType() != 2) break;
                            return true;
                        }
                    }
                    continue block7;
                }
            }
        }
        return false;
    }
}

