/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.BaseOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class BatchOutputStrategy
extends BaseOutputStrategy {
    private int detailStartRowIndex = 3;
    private int tempRowIndex = 0;

    public BatchOutputStrategy(Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory, ExcelTemplate excelTemplate) {
        super(workbook, stampExcelStyleFactory, excelTemplate);
    }

    @Override
    public void insertRow(int n, OutputRowProcess outputRowProcess) {
        ExcelUtil.insertRow((Sheet)this.curSheet, (int)(this.detailStartRowIndex + n));
    }

    @Override
    public void outputCell(Object object, int n, int n2, ExcelTemplateField excelTemplateField, boolean bl) {
        this.setCellValue(object, this.detailStartRowIndex + n, n2, excelTemplateField);
        this.tempRowIndex = Math.max(this.tempRowIndex, n);
    }

    @Override
    public void postOutputExcel(ExcelTemplate excelTemplate) {
        this.detailStartRowIndex += this.tempRowIndex + 1;
        this.tempRowIndex = 0;
    }
}

