/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelBorder;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFont;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import java.awt.Color;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class ExcelStyleFactory {
    private Workbook workbook = null;
    private HashMap<String, CellStyle> styleMap = new HashMap();
    private CellStyle defaultStyle = null;

    public ExcelStyleFactory(Workbook workbook) {
        this.workbook = workbook;
        this.defaultStyle = workbook.createCellStyle();
        this.defaultStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.defaultStyle.setAlignment(HorizontalAlignment.CENTER);
        this.defaultStyle.setFont(this.createDefaultFont(workbook));
    }

    public CellStyle getCellStyle(ExcelCell object) {
        CellStyle cellStyle = null;
        if ((object = ((ExcelCell)object).getDisplay()) == null) {
            return this.defaultStyle;
        }
        String string = ((ExcelDisplay)object).createStyleKey();
        if (this.styleMap.containsKey(string)) {
            cellStyle = this.styleMap.get(string);
        }
        if (cellStyle == null) {
            Object object2;
            cellStyle = this.workbook.createCellStyle();
            this.styleMap.put(string, cellStyle);
            cellStyle.setAlignment(this.tranExcelHAlignment(((ExcelDisplay)object).getHAlign()));
            cellStyle.setVerticalAlignment(this.tranExcelVAlignment(((ExcelDisplay)object).getVAlign()));
            cellStyle.setWrapText(((ExcelDisplay)object).isWrapText());
            if (((ExcelDisplay)object).getFormat() != null) {
                string = "0";
                if (((ExcelDisplay)object).getFormat().getFormatString() != null) {
                    string = ((ExcelDisplay)object).getFormat().getFormatString();
                }
                object2 = (XSSFDataFormat)this.workbook.createDataFormat();
                cellStyle.setDataFormat(object2.getFormat(string));
            }
            ExcelStyleFactory excelStyleFactory = this;
            string = excelStyleFactory.createDefaultFont(excelStyleFactory.workbook);
            if (((ExcelDisplay)object).getFont() != null) {
                string = this.getExcelFont(((ExcelDisplay)object).getFont());
            }
            if (!((String)(object2 = ((ExcelDisplay)object).getForeColor())).isEmpty()) {
                string.setColor(IndexedColors.valueOf((String)((String)object2).toUpperCase()).index);
            }
            cellStyle.setFont((Font)string);
            string = ((ExcelDisplay)object).getBackColor();
            if (!string.isEmpty()) {
                cellStyle.setFillForegroundColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (((ExcelDisplay)object).getBorder() != null) {
                object = ((ExcelDisplay)object).getBorder();
                cellStyle.setBorderLeft(this.tranExcelBorder(((ExcelBorder)object).getLeftStyle()));
                cellStyle.setBorderTop(this.tranExcelBorder(((ExcelBorder)object).getTopStyle()));
                cellStyle.setBorderRight(this.tranExcelBorder(((ExcelBorder)object).getRightStyle()));
                cellStyle.setBorderBottom(this.tranExcelBorder(((ExcelBorder)object).getBottomStyle()));
                string = ((ExcelBorder)object).getLeftColor();
                if (!string.isEmpty()) {
                    cellStyle.setLeftBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getTopColor()).isEmpty()) {
                    cellStyle.setTopBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getRightColor()).isEmpty()) {
                    cellStyle.setRightBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getBottomColor()).isEmpty()) {
                    cellStyle.setBottomBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
            }
        }
        return cellStyle;
    }

    public CellStyle getCellStyle(MetaComponent metaComponent) {
        String string = this.createCellStyleKey(metaComponent);
        if (this.styleMap.containsKey(string)) {
            return this.styleMap.get(string);
        }
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.setBorderStyle(metaComponent, xSSFCellStyle);
        metaComponent = metaComponent.getFormat();
        if (metaComponent == null) {
            this.styleMap.put(string, (CellStyle)xSSFCellStyle);
            return xSSFCellStyle;
        }
        xSSFCellStyle.setAlignment(this.tranExcelHAlignment(metaComponent.getHAlign()));
        xSSFCellStyle.setVerticalAlignment(this.tranExcelVAlignment(metaComponent.getVAlign()));
        ExcelStyleFactory excelStyleFactory = this;
        XSSFFont xSSFFont = excelStyleFactory.createDefaultXSSFFont(excelStyleFactory.workbook);
        String string2 = metaComponent.getForeColor();
        if (!StringUtil.isBlankOrNull((String)string2)) {
            string2 = this.setfontStyle(string2);
            xSSFFont.setColor((XSSFColor)string2);
        }
        if (metaComponent.getFont() != null) {
            this.getExcelFont(metaComponent.getFont(), (Font)xSSFFont);
        }
        xSSFCellStyle.setFont((Font)xSSFFont);
        string2 = metaComponent.getBackColor();
        if (!StringUtil.isBlankOrNull((String)string2)) {
            metaComponent = this.setfontStyle(string2);
            xSSFCellStyle.setFillForegroundColor((XSSFColor)metaComponent);
            xSSFCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        this.styleMap.put(string, (CellStyle)xSSFCellStyle);
        return xSSFCellStyle;
    }

    private String createCellStyleKey(MetaComponent metaComponent) {
        String string = "";
        string = string + (metaComponent.getBorderStyle() == null ? "" : metaComponent.getBorderStyle());
        string = string + ("_" + metaComponent.getBorderColor() == null ? "" : metaComponent.getBorderColor());
        MetaFormat metaFormat = metaComponent.getFormat();
        if (metaComponent.getFormat() == null) {
            return string;
        }
        string = string + "_" + metaFormat.getHAlign();
        string = string + "_" + metaFormat.getVAlign();
        string = string + ("_" + metaComponent.getForeColor() == null ? "" : metaComponent.getForeColor());
        string = string + ("_" + metaComponent.getBackColor() == null ? "" : metaComponent.getBackColor());
        metaComponent = metaFormat.getFont();
        if (metaComponent == null) {
            return string;
        }
        string = string + "_" + (metaComponent.getSize() == -1 ? "12" : metaComponent.getSize());
        string = string + "_" + (StringUtil.isBlankOrNull((String)metaComponent.getName()) ? "\u5b8b\u4f53" : metaComponent.getName());
        string = string + ("_" + metaComponent.isBold() == null ? "" : metaComponent.isBold());
        return string + ("_" + metaComponent.isItalic() == null ? "" : metaComponent.isItalic());
    }

    private void setBorderStyle(MetaComponent object, XSSFCellStyle xSSFCellStyle) {
        String[] stringArray = object.getBorderStyle();
        object = object.getBorderColor();
        if (!StringUtil.isBlankOrNull((String)stringArray)) {
            if ((stringArray = stringArray.split(" ")).length == 1) {
                xSSFCellStyle.setBorderTop(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderRight(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderBottom(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderLeft(this.tranExcelBorder(stringArray[0]));
                if (!StringUtil.isBlankOrNull((String)object) && this.tranExcelBorder(stringArray[0]) != BorderStyle.NONE) {
                    object = this.setfontStyle((String)object);
                    xSSFCellStyle.setTopBorderColor((XSSFColor)object);
                    xSSFCellStyle.setRightBorderColor((XSSFColor)object);
                    xSSFCellStyle.setBottomBorderColor((XSSFColor)object);
                    xSSFCellStyle.setLeftBorderColor((XSSFColor)object);
                    return;
                }
            } else if (stringArray.length == 2) {
                xSSFCellStyle.setBorderTop(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderRight(this.tranExcelBorder(stringArray[1]));
                xSSFCellStyle.setBorderBottom(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderLeft(this.tranExcelBorder(stringArray[1]));
                if (!StringUtil.isBlankOrNull((String)object)) {
                    object = this.setfontStyle((String)object);
                    if (this.tranExcelBorder(stringArray[0]) != BorderStyle.NONE) {
                        xSSFCellStyle.setTopBorderColor((XSSFColor)object);
                        xSSFCellStyle.setBottomBorderColor((XSSFColor)object);
                    }
                    if (this.tranExcelBorder(stringArray[1]) != BorderStyle.NONE) {
                        xSSFCellStyle.setRightBorderColor((XSSFColor)object);
                        xSSFCellStyle.setLeftBorderColor((XSSFColor)object);
                    }
                    return;
                }
            } else if (stringArray.length == 4) {
                xSSFCellStyle.setBorderTop(this.tranExcelBorder(stringArray[0]));
                xSSFCellStyle.setBorderRight(this.tranExcelBorder(stringArray[1]));
                xSSFCellStyle.setBorderBottom(this.tranExcelBorder(stringArray[2]));
                xSSFCellStyle.setBorderLeft(this.tranExcelBorder(stringArray[3]));
                if (!StringUtil.isBlankOrNull((String)object)) {
                    object = this.setfontStyle((String)object);
                    if (this.tranExcelBorder(stringArray[0]) != BorderStyle.NONE) {
                        xSSFCellStyle.setTopBorderColor((XSSFColor)object);
                    }
                    if (this.tranExcelBorder(stringArray[1]) != BorderStyle.NONE) {
                        xSSFCellStyle.setRightBorderColor((XSSFColor)object);
                    }
                    if (this.tranExcelBorder(stringArray[2]) != BorderStyle.NONE) {
                        xSSFCellStyle.setBottomBorderColor((XSSFColor)object);
                    }
                    if (this.tranExcelBorder(stringArray[3]) != BorderStyle.NONE) {
                        xSSFCellStyle.setLeftBorderColor((XSSFColor)object);
                    }
                }
            }
        }
    }

    private XSSFColor setfontStyle(String string) {
        int n = Integer.valueOf(string.substring(1, 3), 16);
        int n2 = Integer.valueOf(string.substring(3, 5), 16);
        int n3 = Integer.valueOf(string.substring(5, 7), 16);
        n3 = Integer.parseInt(String.valueOf(String.format("0xFF%02X%02X%02X", n, n2, n3).substring(3)), 16);
        Color color = new Color(n3);
        return new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap());
    }

    private HorizontalAlignment tranExcelHAlignment(int n) {
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
        switch (n) {
            case 1: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 0: {
                horizontalAlignment = HorizontalAlignment.LEFT;
                break;
            }
            case 2: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            }
        }
        return horizontalAlignment;
    }

    private VerticalAlignment tranExcelVAlignment(int n) {
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        switch (n) {
            case 1: {
                verticalAlignment = VerticalAlignment.CENTER;
                break;
            }
            case 2: {
                verticalAlignment = VerticalAlignment.BOTTOM;
                break;
            }
            case 0: {
                verticalAlignment = VerticalAlignment.TOP;
            }
        }
        return verticalAlignment;
    }

    private BorderStyle tranExcelBorder(int n) {
        BorderStyle borderStyle = BorderStyle.NONE;
        switch (n) {
            case 0: {
                borderStyle = BorderStyle.NONE;
                break;
            }
            case 1: {
                borderStyle = BorderStyle.DOUBLE;
                break;
            }
            case 2: {
                borderStyle = BorderStyle.THIN;
                break;
            }
            case 3: {
                borderStyle = BorderStyle.MEDIUM;
                break;
            }
            case 4: {
                borderStyle = BorderStyle.DASHED;
                break;
            }
            case 5: {
                borderStyle = BorderStyle.HAIR;
                break;
            }
            case 6: {
                borderStyle = BorderStyle.THICK;
            }
        }
        return borderStyle;
    }

    private BorderStyle tranExcelBorder(String string) {
        BorderStyle borderStyle = BorderStyle.NONE;
        int n = -1;
        switch (string.hashCode()) {
            case 2433880: {
                if (!string.equals("None")) break;
                n = 0;
                break;
            }
            case 2052876273: {
                if (!string.equals("Double")) break;
                n = 1;
                break;
            }
            case 2605753: {
                if (!string.equals("Thin")) break;
                n = 2;
                break;
            }
            case -1994163307: {
                if (!string.equals("Medium")) break;
                n = 3;
                break;
            }
            case 2039892945: {
                if (!string.equals("Dashed")) break;
                n = 4;
                break;
            }
            case 2241538: {
                if (!string.equals("Hair")) break;
                n = 5;
                break;
            }
            case 80778109: {
                if (!string.equals("Thick")) break;
                n = 6;
            }
        }
        switch (n) {
            case 0: {
                borderStyle = BorderStyle.NONE;
                break;
            }
            case 1: {
                borderStyle = BorderStyle.DOUBLE;
                break;
            }
            case 2: {
                borderStyle = BorderStyle.THIN;
                break;
            }
            case 3: {
                borderStyle = BorderStyle.MEDIUM;
                break;
            }
            case 4: {
                borderStyle = BorderStyle.DASHED;
                break;
            }
            case 5: {
                borderStyle = BorderStyle.HAIR;
                break;
            }
            case 6: {
                borderStyle = BorderStyle.THICK;
            }
        }
        return borderStyle;
    }

    private Font getExcelFont(ExcelFont excelFont) {
        Font font = this.workbook.createFont();
        font.setBold(excelFont.isBold());
        font.setItalic(excelFont.isItalic());
        font.setFontName(excelFont.getName());
        font.setFontHeightInPoints(excelFont.getSize());
        return font;
    }

    private Font getExcelFont(MetaFont metaFont, Font font) {
        if (metaFont.isBold() != null) {
            font.setBold(metaFont.isBold().booleanValue());
        }
        if (metaFont.isBold() != null) {
            font.setItalic(metaFont.isItalic().booleanValue());
        }
        if (!StringUtil.isBlankOrNull((String)metaFont.getName())) {
            font.setFontName(metaFont.getName());
        } else {
            font.setFontName("\u5b8b\u4f53");
        }
        if (metaFont.getSize() == -1) {
            font.setFontHeightInPoints((short)12);
        } else {
            font.setFontHeightInPoints(metaFont.getSize().shortValue());
        }
        return font;
    }

    private Font createDefaultFont(Workbook workbook) {
        workbook = workbook.createFont();
        workbook.setBold(false);
        workbook.setItalic(false);
        workbook.setFontName("\u5b8b\u4f53");
        workbook.setFontHeightInPoints((short)12);
        return workbook;
    }

    private XSSFFont createDefaultXSSFFont(Workbook workbook) {
        workbook = (XSSFFont)workbook.createFont();
        workbook.setBold(false);
        workbook.setItalic(false);
        workbook.setFontName("\u5b8b\u4f53");
        workbook.setFontHeightInPoints((short)12);
        return workbook;
    }

    public CellStyle getDefaultStyle() {
        return this.defaultStyle;
    }
}

