package com.bokesoft.yigo.excel;

import com.bokesoft.yes.excel.parser.ExcelContext;
import com.bokesoft.yes.parser.IFunImpl;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.parser.IExecutor;

public abstract class BaseExportExcelFunctionImpl implements IFunImpl {

	@Override
	public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
		return this.evalImpl(name, (ExcelContext)context, args);
	}
	
	/**
	 * 执行函数
	 * @param name 函数名称
	 * @param context 上下文
	 * @param args 参数集合
	 * @return 函数返回值
	 * @throws Throwable 执行异常
	 */
	public abstract Object evalImpl(String name, ExcelContext context, Object[] args)
			throws Throwable;
	
	@Override
	public boolean isAsync() {
		return false;
	}
}
