package com.bokesoft.yes.excel.utils;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ImportDictionaryHander {
	private String itemKey = null;

	private HashMap<String, ArrayList<String>> importFields = null;

	private Workbook workbook = null;
	
	private MetaDataObject metaDataObject = null; 
	
	public static String SEPARATOR = ";";

	public ImportDictionaryHander(DefaultContext context, Workbook workbook) throws Throwable {
		this.workbook = workbook;
		init(context);
	}

	private void init(DefaultContext context) throws Throwable {
		Sheet sheet = null;

		// 第一个sheet中存储ItemKey
		sheet = workbook.getSheetAt(0);
		itemKey = ExcelUtil.getCellValue(sheet, 0, 0).toString();
		metaDataObject = context.getVE().getMetaFactory().getDataObject(itemKey);

		String tableKey = null;
		ArrayList<String> list = null;
		importFields = new HashMap<String, ArrayList<String>>();
		int sheetCount = workbook.getNumberOfSheets();
		for (int i = 0; i < sheetCount; i++) {
			sheet = workbook.getSheetAt(i);
			tableKey = sheet.getSheetName();
			list = new ArrayList<String>();
			importFields.put(tableKey, list);

			int colIndex = 1;
			while (true) {
				String fieldKey = ExcelUtil.getCellValue(sheet, 0, colIndex).toString();
				if (fieldKey.isEmpty()) {
					break;
				}
				list.add(fieldKey);
				colIndex++;
			}
		}
	}

	public String getItemKey() {
		return itemKey;
	}

	public HashMap<String, ArrayList<String>> getImportFields() {
		return importFields;
	}
	
	public ArrayList<String> getFieldsByTable(String tableKey) {
		return importFields.get(tableKey);
	}
	
	public String getInsertSQLByTable(String tableKey) {
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		ArrayList<String> list = importFields.get(tableKey);
		if (list == null || list.size() == 0) {
			return "";
		}
		
		String sql = "insert into " + metaTable.getBindingDBTableName();
		String fields = "OID,POID,SOID,VERID,DVERID";
		String values = "?,?,?,?,?";
		for (String field : list) {
			String columnKey = field.split(SEPARATOR)[0];
			String DBName = getDBColumnNameByKey(metaTable, columnKey);
			fields = fields + "," + DBName;
			values = values + ",?";
		}
		sql = sql + " (" + fields + ") values (" + values +")";
		
		return sql;
	}
	
	public String getUpdateSQLByTable(String tableKey) {
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		ArrayList<String> list = importFields.get(tableKey);
		if (list == null || list.size() == 0) {
			return "";
		}
		
		String sql = "update " + metaTable.getBindingDBTableName() + " set ";
		String fields = "";
		for (String field : list) {
			String columnKey = field.split(SEPARATOR)[0];
			String DBName = getDBColumnNameByKey(metaTable, columnKey);
			fields = fields + "," + DBName + "=?";
		}
		
		String DBName = getDBColumnNameByKey(metaTable, "SOID");
		sql = sql + fields.substring(1) + " where "+DBName+"=?";
		
		return sql;
	}
	
	public String getDeleteSQLByTable(String tableKey) {
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		String DBName = getDBColumnNameByKey(metaTable, "SOID");
		String sql = "delete from " + metaTable.getBindingDBTableName() + " where "+DBName+"=?";
		return sql;
	}
	
	private String getDBColumnNameByKey(MetaTable metaTable, String key) {
		MetaColumn column = metaTable.get(key);
		return column.getBindingDBColumnName(); 
	}
	
}
