package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Excel虚拟表格中计算扩展时用的 记录非最后一行表头的扩展属性 记录当前当前单元格的扩展信息以及下一行对应单元格的扩展信息
 *
 */

public class ExcelColumnExpandCellGroup implements IExcelColumnCellObject {
	private ExcelCell cell = null;

	/** 记录单元格的实际列号*/
	private int rowIndex = -1;
	
	private boolean isLeaf = false;

	/**
	 * 记录下属单元格和自身的扩展单元格
	 */
	private ArrayList<IExcelColumnCellObject> objectArray = new ArrayList<IExcelColumnCellObject>();;

	public void setCell(ExcelCell cell) {
		this.cell = cell;
	}

	public ExcelCell getCell() {
		return cell;
	}

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}

	public int getRowIndex() {
		return rowIndex;
	}


	public boolean isLeaf() {
		return isLeaf;
	}

	public void setLeaf(boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public void add(IExcelColumnCellObject obj) {
		objectArray.add(obj);
	}

	public Iterator<IExcelColumnCellObject> iterator() {
		return objectArray.iterator();
	}

	@Override
	public int getObjectType() {
		return IExcelColumnCellObject.Group;
	}

	public void clear() {
		objectArray.clear();
	}

	public void addAll(List<IExcelColumnCellObject> tmpList) {
		objectArray.addAll(tmpList);
	}

	public IExcelColumnCellObject clone() {
		ExcelColumnExpandCellGroup newGroup = new ExcelColumnExpandCellGroup();
		newGroup.setCell(cell);
		newGroup.setLeaf(isLeaf);
		newGroup.setRowIndex(rowIndex);
		newGroup.setCount(count);
		
		Iterator<IExcelColumnCellObject> it = this.objectArray.iterator();
		IExcelColumnCellObject cellObject = null;
		while ( it.hasNext() ) {
			cellObject = it.next();
			newGroup.add(cellObject.clone());
		}

		return newGroup;
	}

	@Override
	public void traversalCell(ColumnExpandItem columnExpandItem,
			IExcelCellProcess process) {
		Iterator<IExcelColumnCellObject> it = objectArray.iterator();
		IExcelColumnCellObject object = null;
		while (it.hasNext()) {
			object = it.next();
			object.traversalCell(columnExpandItem, process);
		}

	}

	private int count = 0;

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}
	
	public void calcCount() {
		this.count = 0;
		Iterator<IExcelColumnCellObject> it = this.objectArray.iterator();
		IExcelColumnCellObject cellObject = null;
		while (it.hasNext()) {
			cellObject = it.next();
			if (cellObject.getObjectType() == IExcelColumnCellObject.Group) {
				ExcelColumnExpandCellGroup group = (ExcelColumnExpandCellGroup) cellObject;
				group.calcCount();
				this.count += group.getCount();
			} else {
				++this.count;
			}
		}
	}

	public int getChildrenCount() {
		int children = 0;
		Iterator<IExcelColumnCellObject> it = this.objectArray.iterator();
		IExcelColumnCellObject cellObject = null;
		while (it.hasNext()) {
			cellObject = it.next();
			if (cellObject.getObjectType() == IExcelColumnCellObject.Group) {
				ExcelColumnExpandCellGroup group = (ExcelColumnExpandCellGroup) cellObject;
				children += group.getChildrenCount();
			} else {
				++children;
			}
		}
		return children;
	}
	
	public void getLeafCells(LinkedList<ExcelCell> cells, int row) {
		Iterator<IExcelColumnCellObject> it = this.objectArray.iterator();
		IExcelColumnCellObject cellObject = null;
		while ( it.hasNext() ) {
			cellObject = it.next();
			cellObject.getLeafCells(cells, row);
		}
	}

	@Override
	public void processMerge(ExcelSheet excelSheet) {
		int rowIndex = cell.getRowIndex();
		
		Iterator<IExcelColumnCellObject> it = this.objectArray.iterator();
		LinkedList<ExcelCell> replaceCells = new LinkedList<ExcelCell>();
		IExcelColumnCellObject cellObject = null;
		int newCellIndex = cell.getCellIndex();
		while (it.hasNext()) {
			cellObject = it.next();

			LinkedList<ExcelCell> cells = new LinkedList<ExcelCell>();
			cellObject.getLeafCells(cells, rowIndex);

			int mergeCount = cells.size();
			for (int i = 0; i < mergeCount; ++i) {
				ExcelCell cell = cells.get(i);
				if (i == 0) {
					if (cell != null) {
						cell.setCellIndex(newCellIndex);
						cell.setMergedColumnSpan(mergeCount);
						replaceCells.add(cell);
						cell.need = true;
					} else {
						cell = replaceCells.getLast();
						cell.setMergedColumnSpan(cell.getMergedColumnSpan() + 1);
					}
				} else {
					if (cell != null) {
						cell.need = false;
					}
				}
			}
		}

		Iterator<IExcelColumnCellObject> itObject = this.objectArray.iterator();
		while (itObject.hasNext()) {
			cellObject = itObject.next();
			cellObject.processMerge(excelSheet);
		}
	}
}
